/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugRunner
extends GenericProgramRunner {
    public static final String PY_DEBUG_RUNNER = "PyDebugRunner";
    public static final String DEBUGGER_MAIN = "pydev/pydevd.py";
    public static final String CLIENT_PARAM = "--client";
    public static final String PORT_PARAM = "--port";
    public static final String FILE_PARAM = "--file";
    public static final String PYCHARM_PROJECT_ROOTS = "PYCHARM_PROJECT_ROOTS";
    public static final String GEVENT_SUPPORT = "GEVENT_SUPPORT";

    @NotNull
    public String getRunnerId() {
        if (PY_DEBUG_RUNNER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugRunner", "getRunnerId"));
        }
        return PY_DEBUG_RUNNER;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/python/debugger/PyDebugRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/python/debugger/PyDebugRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof AbstractPythonRunConfiguration && ((AbstractPythonRunConfiguration)profile).canRunWithCoverage();
    }

    protected RunContentDescriptor doExecute(final @NotNull Project project, @NotNull RunProfileState profileState, RunContentDescriptor contentToReuse, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebugRunner", "doExecute"));
        }
        if (profileState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileState", "com/jetbrains/python/debugger/PyDebugRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/debugger/PyDebugRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final PythonCommandLineState pyState = (PythonCommandLineState)profileState;
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        int serverLocalPort = serverSocket.getLocalPort();
        RunProfile profile = env.getRunProfile();
        final ExecutionResult result = pyState.execute(env.getExecutor(), PyDebugRunner.createCommandLinePatchers(project, pyState, profile, serverLocalPort));
        XDebugSession session = XDebuggerManager.getInstance((Project)project).startSession((ProgramRunner)this, env, contentToReuse, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/debugger/PyDebugRunner$1", "start"));
                }
                PyDebugProcess pyDebugProcess = new PyDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), pyState.isMultiprocessDebug());
                PyDebugRunner.createConsoleCommunicationAndSetupActions(project, result, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugRunner$1", "start"));
                }
                return pyDebugProcess2;
            }
        });
        return session.getRunContentDescriptor();
    }

    public static int findIndex(List<String> paramList, String paramName) {
        for (int i = 0; i < paramList.size(); ++i) {
            if (!paramName.equals(paramList.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    public static void createConsoleCommunicationAndSetupActions(@NotNull Project project, @NotNull ExecutionResult result, @NotNull PyDebugProcess debugProcess, @NotNull XDebugSession session) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebugRunner", "createConsoleCommunicationAndSetupActions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/debugger/PyDebugRunner", "createConsoleCommunicationAndSetupActions"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/PyDebugRunner", "createConsoleCommunicationAndSetupActions"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/debugger/PyDebugRunner", "createConsoleCommunicationAndSetupActions"));
        }
        ExecutionConsole console = result.getExecutionConsole();
        if (console instanceof PythonDebugLanguageConsoleView) {
            ProcessHandler processHandler = result.getProcessHandler();
            PyDebugRunner.initDebugConsoleView(project, debugProcess, (PythonDebugLanguageConsoleView)console, processHandler, session);
        }
    }

    public static PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, final XDebugSession session) {
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess);
        pythonConsoleView.setConsoleCommunication((ConsoleCommunication)debugConsoleCommunication);
        PydevDebugConsoleExecuteActionHandler consoleExecuteActionHandler = new PydevDebugConsoleExecuteActionHandler(pythonConsoleView, processHandler, (ConsoleCommunication)debugConsoleCommunication);
        pythonConsoleView.setExecutionHandler(consoleExecuteActionHandler);
        debugProcess.getSession().addSessionListener((XDebugSessionListener)consoleExecuteActionHandler);
        new LanguageConsoleBuilder(pythonConsoleView).processHandler(processHandler).initActions(consoleExecuteActionHandler, "py");
        debugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                session.rebuildViews();
            }

            public void inputRequested() {
            }
        });
        return debugConsoleCommunication;
    }

    @Nullable
    private static CommandLinePatcher createRunConfigPatcher(RunProfileState state2, RunProfile profile) {
        AbstractPythonRunConfiguration runConfigPatcher = null;
        if (state2 instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration) {
            runConfigPatcher = (AbstractPythonRunConfiguration)profile;
        }
        return runConfigPatcher;
    }

    public static CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state2, RunProfile profile, int serverLocalPort) {
        return new CommandLinePatcher[]{PyDebugRunner.createDebugServerPatcher(project, state2, serverLocalPort), PyDebugRunner.createRunConfigPatcher((RunProfileState)state2, profile)};
    }

    private static CommandLinePatcher createDebugServerPatcher(final Project project, final PythonCommandLineState pyState, final int serverLocalPort) {
        return new CommandLinePatcher(){

            @Override
            public void patchCommandLine(GeneralCommandLine commandLine) {
                ParametersList parametersList = commandLine.getParametersList();
                ParamsGroup debugParams = parametersList.getParamsGroup("Debugger");
                ParamsGroup exeParams = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor flavor = pyState.getSdkFlavor();
                if (flavor != null) {
                    assert (exeParams != null);
                    for (String option : flavor.getExtraDebugOptions()) {
                        exeParams.addParameter(option);
                    }
                }
                assert (debugParams != null);
                PyDebugRunner.fillDebugParameters(project, debugParams, serverLocalPort, pyState, commandLine);
            }
        };
    }

    private static void fillDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, int serverLocalPort, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine generalCommandLine) {
        String[] debuggerArgs;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebugRunner", "fillDebugParameters"));
        }
        if (debugParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugParams", "com/jetbrains/python/debugger/PyDebugRunner", "fillDebugParameters"));
        }
        if (pyState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyState", "com/jetbrains/python/debugger/PyDebugRunner", "fillDebugParameters"));
        }
        if (generalCommandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalCommandLine", "com/jetbrains/python/debugger/PyDebugRunner", "fillDebugParameters"));
        }
        debugParams.addParameter(PythonHelpersLocator.getHelperPath(DEBUGGER_MAIN));
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter("--multiproc");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            debugParams.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debugParams.addParameter("--save-signatures");
            PyDebugRunner.addProjectRootsToEnv(project, generalCommandLine);
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportGeventDebugging()) {
            generalCommandLine.getEnvironment().put(GEVENT_SUPPORT, "True");
        }
        for (String s : debuggerArgs = new String[]{CLIENT_PARAM, "127.0.0.1", PORT_PARAM, String.valueOf(serverLocalPort), FILE_PARAM}) {
            debugParams.addParameter(s);
        }
    }

    private static void addProjectRootsToEnv(@NotNull Project project, @NotNull GeneralCommandLine commandLine) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebugRunner", "addProjectRootsToEnv"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/python/debugger/PyDebugRunner", "addProjectRootsToEnv"));
        }
        ArrayList roots = Lists.newArrayList();
        for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            roots.add(contentRoot.getPath());
        }
        commandLine.getEnvironment().put(PYCHARM_PROJECT_ROOTS, StringUtil.join((Collection)roots, (String)File.pathSeparator));
    }
}

