/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remote.RemoteProcessHandlerBase;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyBreakpointHandlerFactory;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyExceptionBreakpointHandler;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyLineBreakpointHandler;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySmartStepIntoHandler;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PySuspendContext;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.MultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.PythonProcessHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugProcess
extends XDebugProcess
implements IPyDebugProcess,
ProcessListener {
    private static final int CONNECTION_TIMEOUT = 60000;
    private final ProcessDebugger myDebugger;
    private final XBreakpointHandler[] myBreakpointHandlers;
    private final PyDebuggerEditorsProvider myEditorsProvider;
    private final ProcessHandler myProcessHandler;
    private final ExecutionConsole myExecutionConsole;
    private final Map<PySourcePosition, XLineBreakpoint> myRegisteredBreakpoints;
    private final Map<String, XBreakpoint<? extends ExceptionBreakpointProperties>> myRegisteredExceptionBreakpoints;
    private final List<PyThreadInfo> mySuspendedThreads;
    private final Map<String, XValueChildrenList> myStackFrameCache;
    private final Map<String, PyDebugValue> myNewVariableValue;
    private boolean myDownloadSources;
    private boolean myClosing;
    private PyPositionConverter myPositionConverter;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler;
    private boolean myWaitingForConnection;
    private PyStackFrame myStackFrameBeforeResume;
    private PyStackFrame myConsoleContextFrame;
    private PyReferrersLoader myReferrersProvider;

    public PyDebugProcess(final @NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, boolean multiProcess) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/debugger/PyDebugProcess", "<init>"));
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/debugger/PyDebugProcess", "<init>"));
        }
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/jetbrains/python/debugger/PyDebugProcess", "<init>"));
        }
        super(session);
        this.myRegisteredBreakpoints = new ConcurrentHashMap<PySourcePosition, XLineBreakpoint>();
        this.myRegisteredExceptionBreakpoints = new ConcurrentHashMap<String, XBreakpoint<? extends ExceptionBreakpointProperties>>();
        this.mySuspendedThreads = Collections.synchronizedList(Lists.newArrayList());
        this.myStackFrameCache = Maps.newHashMap();
        this.myNewVariableValue = Maps.newHashMap();
        this.myDownloadSources = false;
        this.myClosing = false;
        this.myWaitingForConnection = false;
        this.myConsoleContextFrame = null;
        session.setPauseActionSupported(true);
        this.myDebugger = multiProcess ? this.createMultiprocessDebugger(serverSocket) : new RemoteDebugger((IPyDebugProcess)this, serverSocket, this.getConnectTimeout());
        ArrayList<XBreakpointHandler> breakpointHandlers = new ArrayList<XBreakpointHandler>();
        breakpointHandlers.add(new PyLineBreakpointHandler(this));
        breakpointHandlers.add(new PyExceptionBreakpointHandler(this));
        for (PyBreakpointHandlerFactory factory : (PyBreakpointHandlerFactory[])Extensions.getExtensions(PyBreakpointHandlerFactory.EP_NAME)) {
            breakpointHandlers.add(factory.createBreakpointHandler(this));
        }
        this.myBreakpointHandlers = breakpointHandlers.toArray(new XBreakpointHandler[breakpointHandlers.size()]);
        this.myEditorsProvider = new PyDebuggerEditorsProvider();
        this.mySmartStepIntoHandler = new PySmartStepIntoHandler(this);
        this.myProcessHandler = processHandler;
        this.myExecutionConsole = executionConsole;
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener((ProcessListener)this);
        }
        this.myPositionConverter = processHandler instanceof PositionConverterProvider ? ((PositionConverterProvider)processHandler).createPositionConverter(this) : new PyLocalPositionConverter();
        this.myDebugger.addCloseListener(new RemoteDebuggerCloseListener(){

            public void closed() {
                PyDebugProcess.this.handleStop();
            }

            public void communicationError() {
                PyDebugProcess.this.detachDebuggedProcess();
            }

            public void detached() {
                PyDebugProcess.this.detachDebuggedProcess();
            }
        });
        session.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void beforeSessionResume() {
                if (session.getCurrentStackFrame() instanceof PyStackFrame) {
                    PyDebugProcess.this.myStackFrameBeforeResume = (PyStackFrame)session.getCurrentStackFrame();
                } else {
                    PyDebugProcess.this.myStackFrameBeforeResume = null;
                }
            }
        });
    }

    private MultiProcessDebugger createMultiprocessDebugger(ServerSocket serverSocket) {
        MultiProcessDebugger debugger = new MultiProcessDebugger((IPyDebugProcess)this, serverSocket, 10000);
        debugger.addOtherDebuggerCloseListener(new MultiProcessDebugger.DebuggerProcessListener(){

            public void threadsClosed(Set<String> threadIds) {
                for (PyThreadInfo t : PyDebugProcess.this.mySuspendedThreads) {
                    if (!threadIds.contains(t.getId()) || !PyDebugProcess.this.getSession().isSuspended()) continue;
                    PyDebugProcess.this.getSession().resume();
                    break;
                }
            }
        });
        return debugger;
    }

    protected void detachDebuggedProcess() {
        this.handleStop();
    }

    protected void handleStop() {
        this.getSession().stop();
    }

    public void setPositionConverter(PyPositionConverter positionConverter) {
        this.myPositionConverter = positionConverter;
    }

    public PyPositionConverter getPositionConverter() {
        return this.myPositionConverter;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugProcess", "getBreakpointHandlers"));
        }
        return this.myBreakpointHandlers;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        PyDebuggerEditorsProvider pyDebuggerEditorsProvider = this.myEditorsProvider;
        if (pyDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugProcess", "getEditorsProvider"));
        }
        return pyDebuggerEditorsProvider;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugProcess", "createConsole"));
        }
        return executionConsole;
    }

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    public void sessionInitialized() {
        this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
    }

    protected void waitForConnection(final String connectionMessage, String connectionTitle) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getSession().getProject(), connectionTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/debugger/PyDebugProcess$4", "run"));
                    }
                    indicator.setText(connectionMessage);
                    try {
                        PyDebugProcess.this.beforeConnect();
                        PyDebugProcess.this.myWaitingForConnection = true;
                        PyDebugProcess.this.myDebugger.waitForConnect();
                        PyDebugProcess.this.myWaitingForConnection = false;
                        PyDebugProcess.this.afterConnect();
                        PyDebugProcess.this.handshake();
                        PyDebugProcess.this.init();
                        PyDebugProcess.this.myDebugger.run();
                    }
                    catch (Exception e) {
                        PyDebugProcess.this.myWaitingForConnection = false;
                        if (PyDebugProcess.this.myProcessHandler != null) {
                            PyDebugProcess.this.myProcessHandler.destroyProcess();
                        }
                        if (PyDebugProcess.this.myClosing) break block4;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((String)("Unable to establish connection with debugger:\n" + e.getMessage()), (String)PyDebugProcess.this.getConnectionTitle());
                            }
                        });
                    }
                }
            }
        });
    }

    public void init() {
        this.getSession().rebuildViews();
        this.registerBreakpoints();
    }

    public int handleDebugPort(int localPort) throws IOException {
        if (this.myProcessHandler instanceof RemoteProcessHandlerBase) {
            return PyDebugProcess.getRemoteTunneledPort(localPort, (RemoteProcessHandlerBase)this.myProcessHandler);
        }
        return localPort;
    }

    protected static int getRemoteTunneledPort(int localPort, @NotNull RemoteProcessHandlerBase handler) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/python/debugger/PyDebugProcess", "getRemoteTunneledPort"));
        }
        try {
            Pair<String, Integer> remoteSocket = handler.obtainRemoteSocket();
            handler.addRemoteForwarding((Integer)remoteSocket.getSecond(), localPort);
            return (Integer)remoteSocket.getSecond();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void recordSignature(PySignature signature) {
        PySignatureCacheManager.getInstance(this.getSession().getProject()).recordSignature(this.myPositionConverter.convertSignature(signature));
    }

    public void showConsole(PyThreadInfo thread) {
        this.myConsoleContextFrame = new PyExecutionStack(this, thread).getTopFrame();
        if (this.myExecutionConsole instanceof PythonDebugLanguageConsoleView) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((PythonDebugLanguageConsoleView)PyDebugProcess.this.myExecutionConsole).enableConsole(false);
                }
            });
        }
    }

    protected void afterConnect() {
    }

    protected void beforeConnect() {
    }

    protected String getConnectionMessage() {
        return "Waiting for connection...";
    }

    protected String getConnectionTitle() {
        return "Connecting To Debugger";
    }

    private void handshake() throws PyDebuggerException {
        String remoteVersion = this.myDebugger.handshake();
        String currentBuild = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        remoteVersion = "@@BUILD_NUMBER@@".equals(remoteVersion) ? currentBuild : (remoteVersion.startsWith("PY-") ? remoteVersion.substring(3) : null);
        this.printToConsole("Connected to pydev debugger (build " + remoteVersion + ")\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        if (remoteVersion != null && !remoteVersion.equals(currentBuild)) {
            this.printToConsole("Warning: wrong debugger version. Use pycharm-debugger.egg from PyCharm installation folder.\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public void printToConsole(String text, ConsoleViewContentType contentType) {
        ((ConsoleView)this.myExecutionConsole).print(text, contentType);
    }

    private void registerBreakpoints() {
        this.registerLineBreakpoints();
        this.registerExceptionBreakpoints();
    }

    private void registerExceptionBreakpoints() {
        for (XBreakpoint<? extends ExceptionBreakpointProperties> bp : this.myRegisteredExceptionBreakpoints.values()) {
            this.addExceptionBreakpoint(bp);
        }
    }

    public void registerLineBreakpoints() {
        for (Map.Entry<PySourcePosition, XLineBreakpoint> entry : this.myRegisteredBreakpoints.entrySet()) {
            this.addBreakpoint(entry.getKey(), entry.getValue());
        }
    }

    public void startStepOver() {
        this.passToCurrentThread(ResumeOrStepCommand.Mode.STEP_OVER);
    }

    public void startStepInto() {
        this.passToCurrentThread(ResumeOrStepCommand.Mode.STEP_INTO);
    }

    public void startStepOut() {
        this.passToCurrentThread(ResumeOrStepCommand.Mode.STEP_OUT);
    }

    public void startSmartStepInto(String functionName) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                this.myDebugger.smartStepInto(suspendedThread.getId(), functionName);
            }
        }
    }

    public void stop() {
        this.myDebugger.close();
    }

    public void resume() {
        this.passToAllThreads(ResumeOrStepCommand.Mode.RESUME);
    }

    public void startPausing() {
        if (this.isConnected()) {
            this.myDebugger.suspendAllThreads();
        }
    }

    private void passToAllThreads(ResumeOrStepCommand.Mode mode) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            for (PyThreadInfo suspendedThread : Lists.newArrayList(this.mySuspendedThreads)) {
                this.myDebugger.resumeOrStep(suspendedThread.getId(), mode);
            }
        }
    }

    private void passToCurrentThread(ResumeOrStepCommand.Mode mode) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            String threadId = this.threadIdBeforeResumeOrStep();
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (threadId != null && !threadId.equals(suspendedThread.getId())) continue;
                this.myDebugger.resumeOrStep(suspendedThread.getId(), mode);
                break;
            }
        }
    }

    @Nullable
    private String threadIdBeforeResumeOrStep() {
        String threadId = null;
        if (this.myStackFrameBeforeResume != null) {
            threadId = this.myStackFrameBeforeResume.getThreadId();
        }
        return threadId;
    }

    protected boolean isConnected() {
        return this.myDebugger.isConnected();
    }

    protected void disconnect() {
        this.myDebugger.disconnect();
        this.cleanUp();
    }

    public boolean isDownloadSources() {
        return this.myDownloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.myDownloadSources = downloadSources;
    }

    protected void cleanUp() {
        this.mySuspendedThreads.clear();
        this.myDownloadSources = false;
    }

    public void runToPosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/debugger/PyDebugProcess", "runToPosition"));
        }
        this.dropFrameCaches();
        if (this.isConnected() && !this.mySuspendedThreads.isEmpty()) {
            PySourcePosition pyPosition = this.myPositionConverter.convertToPython(position);
            String type = "python-line";
            Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
            if (document != null) {
                for (XBreakpointType breakpointType : (XBreakpointType[])Extensions.getExtensions((ExtensionPointName)XBreakpointType.EXTENSION_POINT_NAME)) {
                    if (!(breakpointType instanceof PyBreakpointType) || !((PyBreakpointType)breakpointType).canPutInDocument(this.getSession().getProject(), document)) continue;
                    type = breakpointType.getId();
                    break;
                }
            }
            this.myDebugger.setTempBreakpoint(type, pyPosition.getFile(), pyPosition.getLine());
            this.passToCurrentThread(ResumeOrStepCommand.Mode.RESUME);
        }
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        this.dropFrameCaches();
        PyStackFrame frame = this.currentFrame();
        return this.evaluate(expression, execute, frame, doTrunc);
    }

    private PyDebugValue evaluate(String expression, boolean execute, PyStackFrame frame, boolean trimResult) throws PyDebuggerException {
        return this.myDebugger.evaluate(frame.getThreadId(), frame.getFrameId(), expression, execute, trimResult);
    }

    public void consoleExec(String command, PyDebugCallback<String> callback) {
        this.dropFrameCaches();
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.consoleExec(frame.getThreadId(), frame.getFrameId(), command, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        if (!this.myStackFrameCache.containsKey(frame.getThreadFrameId())) {
            XValueChildrenList values = this.myDebugger.loadFrame(frame.getThreadId(), frame.getFrameId());
            this.myStackFrameCache.put(frame.getThreadFrameId(), values);
        }
        return this.applyNewValue(this.myStackFrameCache.get(frame.getThreadFrameId()), frame.getThreadFrameId());
    }

    private XValueChildrenList applyNewValue(XValueChildrenList pyDebugValues, String threadFrameId) {
        if (this.myNewVariableValue.containsKey(threadFrameId)) {
            PyDebugValue newValue = this.myNewVariableValue.get(threadFrameId);
            XValueChildrenList res = new XValueChildrenList();
            for (int i = 0; i < pyDebugValues.size(); ++i) {
                String name = pyDebugValues.getName(i);
                if (name.equals(newValue.getName())) {
                    res.add(name, (XValue)newValue);
                    continue;
                }
                res.add(name, pyDebugValues.getValue(i));
            }
            return res;
        }
        return pyDebugValues;
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.loadVariable(frame.getThreadId(), frame.getFrameId(), var);
    }

    public void loadReferrers(PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.loadReferrers(frame.getThreadId(), frame.getFrameId(), var, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    public void changeVariable(PyDebugValue var, String value) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        PyDebugValue newValue = this.myDebugger.changeVariable(frame.getThreadId(), frame.getFrameId(), var, value);
        this.myNewVariableValue.put(frame.getThreadFrameId(), newValue);
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        if (this.myReferrersProvider == null) {
            this.myReferrersProvider = new PyReferrersLoader((IPyDebugProcess)this);
        }
        return this.myReferrersProvider;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.loadArrayItems(frame.getThreadId(), frame.getFrameId(), var, rowOffset, colOffset, rows, cols, format);
    }

    @Nullable
    public String loadSource(String path) {
        return this.myDebugger.loadSource(path);
    }

    public boolean canSaveToTemp(String name) {
        Project project = this.getSession().getProject();
        return PyDebugSupportUtils.canSaveToTemp(project, name);
    }

    private PyStackFrame currentFrame() throws PyDebuggerException {
        if (!this.isConnected()) {
            throw new PyDebuggerException("Disconnected");
        }
        PyStackFrame frame = (PyStackFrame)this.getSession().getCurrentStackFrame();
        if (frame == null && this.myConsoleContextFrame != null) {
            return this.myConsoleContextFrame;
        }
        if (frame == null) {
            throw new PyDebuggerException("Process is running");
        }
        return frame;
    }

    private String getFunctionName(final XLineBreakpoint breakpoint) {
        final VirtualFile file = breakpoint.getSourcePosition().getFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        final Project project = this.getSession().getProject();
        final String[] funcName = new String[1];
        if (document != null && file.getFileType() == PythonFileType.INSTANCE) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiElement psiElement = XDebuggerUtil.getInstance().findContextElement(file, breakpoint.getSourcePosition().getOffset(), project, false);
                    PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class);
                    if (function != null) {
                        funcName[0] = function.getName();
                    }
                }
            });
        }
        return funcName[0];
    }

    public void addBreakpoint(PySourcePosition position, XLineBreakpoint breakpoint) {
        this.myRegisteredBreakpoints.put(position, breakpoint);
        if (this.isConnected()) {
            this.myDebugger.setBreakpointWithFuncName(breakpoint.getType().getId(), position.getFile(), position.getLine(), breakpoint.getCondition(), breakpoint.getLogExpression(), this.getFunctionName(breakpoint));
        }
    }

    public void removeBreakpoint(PySourcePosition position) {
        XLineBreakpoint breakpoint = this.myRegisteredBreakpoints.get(position);
        if (breakpoint != null) {
            this.myRegisteredBreakpoints.remove(position);
            if (this.isConnected()) {
                this.myDebugger.removeBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine());
            }
        }
    }

    public void addExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.myRegisteredExceptionBreakpoints.put(((ExceptionBreakpointProperties)breakpoint.getProperties()).getException(), breakpoint);
        if (this.isConnected()) {
            this.myDebugger.addExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public void removeExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.myRegisteredExceptionBreakpoints.remove(((ExceptionBreakpointProperties)breakpoint.getProperties()).getException());
        if (this.isConnected()) {
            this.myDebugger.removeExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public Collection<PyThreadInfo> getThreads() {
        return this.myDebugger.getThreads();
    }

    public void threadSuspended(PyThreadInfo threadInfo) {
        if (!this.mySuspendedThreads.contains(threadInfo)) {
            this.mySuspendedThreads.add(threadInfo);
            List frames = threadInfo.getFrames();
            if (frames != null) {
                PySuspendContext suspendContext = new PySuspendContext(this, threadInfo);
                XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition position = ((PyStackFrameInfo)frames.get(0)).getPosition();
                    breakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties>)this.myRegisteredBreakpoints.get(position);
                    if (breakpoint == null) {
                        this.myDebugger.removeTempBreakpoint(position.getFile(), position.getLine());
                    }
                } else if (threadInfo.isExceptionBreak()) {
                    String exceptionName = threadInfo.getMessage();
                    threadInfo.setMessage(null);
                    if (exceptionName != null) {
                        breakpoint = this.myRegisteredExceptionBreakpoints.get(exceptionName);
                    }
                }
                if (breakpoint != null) {
                    if (!this.getSession().breakpointReached((XBreakpoint)breakpoint, threadInfo.getMessage(), (XSuspendContext)suspendContext)) {
                        this.resume();
                    }
                } else {
                    this.getSession().positionReached((XSuspendContext)suspendContext);
                }
            }
        }
    }

    public void threadResumed(PyThreadInfo threadInfo) {
        this.mySuspendedThreads.remove(threadInfo);
    }

    private void dropFrameCaches() {
        this.myStackFrameCache.clear();
        this.myNewVariableValue.clear();
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String prefix) throws Exception {
        if (this.isConnected()) {
            this.dropFrameCaches();
            PyStackFrame frame = this.currentFrame();
            List list = this.myDebugger.getCompletions(frame.getThreadId(), frame.getFrameId(), prefix);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugProcess", "getCompletions"));
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebugProcess", "getCompletions"));
        }
        return arrayList;
    }

    public void startNotified(ProcessEvent event) {
    }

    public void processTerminated(ProcessEvent event) {
        this.myDebugger.close();
    }

    public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
        this.myClosing = true;
        this.setKillingStrategy();
    }

    private void setKillingStrategy() {
        if (this.myProcessHandler instanceof PythonProcessHandler) {
            ((PythonProcessHandler)this.myProcessHandler).setShouldKillProcessSoftly(false);
        }
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
    }

    public PyStackFrame createStackFrame(PyStackFrameInfo frameInfo) {
        return new PyStackFrame(this.getSession().getProject(), (PyFrameAccessor)this, frameInfo, this.getPositionConverter().convertFromPython(frameInfo.getPosition()));
    }

    public String getCurrentStateMessage() {
        if (this.getSession().isStopped()) {
            return XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
        }
        if (this.isConnected()) {
            return XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
        }
        return this.getConnectionMessage();
    }

    public void addProcessListener(ProcessListener listener) {
        ProcessHandler handler = this.doGetProcessHandler();
        if (handler != null) {
            handler.addProcessListener(listener);
        }
    }

    public boolean isWaitingForConnection() {
        return this.myWaitingForConnection;
    }

    public void setWaitingForConnection(boolean waitingForConnection) {
        this.myWaitingForConnection = waitingForConnection;
    }

    public int getConnectTimeout() {
        return 60000;
    }
}

