/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassTreeChooserDialog
extends AbstractTreeClassChooserDialog<PyClass> {
    public PyClassTreeChooserDialog(String title, Project project, GlobalSearchScope scope, @Nullable TreeChooser.Filter<PyClass> classFilter, @Nullable PyClass initialClass) {
        super(title, project, scope, PyClass.class, classFilter, initialClass);
    }

    @Override
    @NotNull
    protected List<PyClass> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        Collection<PyClass> classes = PyClassNameIndex.find(name, this.getProject(), searchScope.isSearchInLibraries());
        ArrayList result = Lists.newArrayList();
        for (PyClass c : classes) {
            if (!this.getFilter().isAccepted((Object)c)) continue;
            result.add(c);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyClassTreeChooserDialog", "getClassesByName"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected PyClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        return null;
    }
}

