/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.PyDebugProcess;
import org.jetbrains.annotations.NotNull;

public abstract class ExceptionBreakpointHandler<T extends ExceptionBreakpointProperties>
extends XBreakpointHandler<XBreakpoint<T>> {
    private final PyDebugProcess myDebugProcess;

    public ExceptionBreakpointHandler(@NotNull PyDebugProcess debugProcess, @NotNull Class<? extends XBreakpointType<XBreakpoint<T>, T>> breakpointTypeClass) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/ExceptionBreakpointHandler", "<init>"));
        }
        if (breakpointTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointTypeClass", "com/jetbrains/python/debugger/ExceptionBreakpointHandler", "<init>"));
        }
        super(breakpointTypeClass);
        this.myDebugProcess = debugProcess;
    }

    public void registerBreakpoint(@NotNull XBreakpoint<T> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/ExceptionBreakpointHandler", "registerBreakpoint"));
        }
        this.myDebugProcess.addExceptionBreakpoint(breakpoint);
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint<T> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/ExceptionBreakpointHandler", "unregisterBreakpoint"));
        }
        this.myDebugProcess.removeExceptionBreakpoint(breakpoint);
    }
}

