/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.python.debugger.PyDebugProcess;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AbstractLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    protected final PyDebugProcess myDebugProcess;
    private final Map<XLineBreakpoint<XBreakpointProperties>, XSourcePosition> myBreakPointPositions;

    public AbstractLineBreakpointHandler(Class<? extends XBreakpointType<XLineBreakpoint<XBreakpointProperties>, ?>> breakpointTypeClass, @NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/AbstractLineBreakpointHandler", "<init>"));
        }
        super(breakpointTypeClass);
        this.myBreakPointPositions = Maps.newHashMap();
        this.myDebugProcess = debugProcess;
    }

    public void reregisterBreakpoints() {
        ArrayList breakpoints = Lists.newArrayList(this.myBreakPointPositions.keySet());
        for (XLineBreakpoint breakpoint : breakpoints) {
            this.unregisterBreakpoint((XLineBreakpoint<XBreakpointProperties>)breakpoint, false);
            this.registerBreakpoint((XLineBreakpoint<XBreakpointProperties>)breakpoint);
        }
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/AbstractLineBreakpointHandler", "registerBreakpoint"));
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position != null) {
            this.myDebugProcess.addBreakpoint(this.myDebugProcess.getPositionConverter().convertToPython(position), breakpoint);
            this.myBreakPointPositions.put(breakpoint, position);
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/AbstractLineBreakpointHandler", "unregisterBreakpoint"));
        }
        XSourcePosition position = this.myBreakPointPositions.get(breakpoint);
        if (position != null) {
            this.myDebugProcess.removeBreakpoint(this.myDebugProcess.getPositionConverter().convertToPython(position));
            this.myBreakPointPositions.remove(breakpoint);
        }
    }
}

