/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.console.parsing.PyConsoleTokenTypes;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.Nullable;

public class PyConsoleParsingContext
extends ParsingContext {
    private final StatementParsing stmtParser;
    private final ExpressionParsing expressionParser;

    public PyConsoleParsingContext(PsiBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag, PythonConsoleData pythonConsoleData, boolean startsWithIPythonSymbol) {
        super(builder, languageLevel, futureFlag);
        this.stmtParser = new ConsoleStatementParsing(this, futureFlag, startsWithIPythonSymbol, pythonConsoleData);
        this.expressionParser = pythonConsoleData.isIPythonEnabled() ? new ConsoleExpressionParsing(this) : new ExpressionParsing(this);
    }

    @Override
    public StatementParsing getStatementParser() {
        return this.stmtParser;
    }

    @Override
    public ExpressionParsing getExpressionParser() {
        return this.expressionParser;
    }

    public static class ConsoleExpressionParsing
    extends ExpressionParsing {
        public ConsoleExpressionParsing(ParsingContext context) {
            super(context);
        }

        @Override
        public boolean parseExpressionOptional() {
            if (this.myBuilder.getTokenType() == PyTokenTypes.PERC || this.myBuilder.getTokenType() == PyConsoleTokenTypes.PLING || this.myBuilder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK) {
                PsiBuilder.Marker expr = this.myBuilder.mark();
                PsiBuilder.Marker command = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
                    this.myBuilder.advanceLexer();
                    command.done(this.getReferenceType());
                } else {
                    expr.drop();
                    command.drop();
                    this.myBuilder.error("Identifier expected.");
                    return false;
                }
                while (this.myBuilder.getTokenType() != null) {
                    this.myBuilder.advanceLexer();
                }
                expr.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
                return true;
            }
            return super.parseExpressionOptional();
        }
    }

    public static class ConsoleStatementParsing
    extends StatementParsing {
        private boolean myStartsWithIPythonSymbol;
        private PythonConsoleData myPythonConsoleData;

        protected ConsoleStatementParsing(ParsingContext context, @Nullable StatementParsing.FUTURE futureFlag, boolean startsWithIPythonSymbol, PythonConsoleData pythonConsoleData) {
            super(context, futureFlag);
            this.myStartsWithIPythonSymbol = startsWithIPythonSymbol;
            this.myPythonConsoleData = pythonConsoleData;
        }

        @Override
        public void parseStatement(ParsingScope scope) {
            if (this.myStartsWithIPythonSymbol) {
                this.parseIPythonCommand();
            } else {
                if (this.myPythonConsoleData.isIPythonEnabled() && this.myPythonConsoleData.isIPythonAutomagic() && this.myPythonConsoleData.isMagicCommand(this.myBuilder.getTokenText())) {
                    this.parseIPythonCommand();
                }
                if (this.myPythonConsoleData.getIndentSize() > 0 && this.myBuilder.getTokenType() == PyTokenTypes.INDENT) {
                    this.myBuilder.advanceLexer();
                }
                super.parseStatement(scope);
            }
        }

        private void parseIPythonCommand() {
            PsiBuilder.Marker ipythonCommand = this.myBuilder.mark();
            while (!this.myBuilder.eof()) {
                this.myBuilder.advanceLexer();
            }
            ipythonCommand.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        }

        @Override
        protected void checkEndOfStatement(ParsingScope scope) {
            if (this.myPythonConsoleData.isIPythonEnabled()) {
                PsiBuilder builder = this.myContext.getBuilder();
                if (builder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
                    builder.advanceLexer();
                } else if (builder.getTokenType() == PyTokenTypes.SEMICOLON) {
                    if (!scope.isSuite()) {
                        builder.advanceLexer();
                        if (builder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
                            builder.advanceLexer();
                        }
                    }
                } else {
                    if (builder.eof()) {
                        return;
                    }
                    if (builder.getTokenType() == PyConsoleTokenTypes.PLING || builder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK) {
                        builder.advanceLexer();
                        if (builder.getTokenType() == PyConsoleTokenTypes.PLING || builder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK) {
                            builder.advanceLexer();
                        }
                        return;
                    }
                    builder.error("End of statement expected");
                }
            } else {
                super.checkEndOfStatement(scope);
            }
        }
    }
}

