/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.console.parsing.PyConsoleParsingContext;
import com.jetbrains.python.console.parsing.PyConsoleTokenTypes;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class PyConsoleParser
extends PyParser {
    private LanguageLevel myLanguageLevel;
    private StatementParsing.FUTURE myFutureFlag;
    private PythonConsoleData myPythonConsoleData;
    private boolean myIPythonStartSymbol;

    public PyConsoleParser(PythonConsoleData pythonConsoleData) {
        this.myPythonConsoleData = pythonConsoleData;
        this.myLanguageLevel = LanguageLevel.getDefault();
    }

    @Override
    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    @Override
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        this.myIPythonStartSymbol = this.myPythonConsoleData.isIPythonEnabled() && PyConsoleParser.startsWithIPythonSpecialSymbol(builder);
        ParsingContext context = this.createParsingContext(builder, this.myLanguageLevel, this.myFutureFlag);
        StatementParsing stmt_parser = context.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)stmt_parser);
        builder.setDebugMode(true);
        while (!builder.eof()) {
            stmt_parser.parseStatement(context.emptyParsingScope());
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/parsing/PyConsoleParser", "parse"));
        }
        return aSTNode;
    }

    public static boolean startsWithIPythonSpecialSymbol(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        return builder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK || tokenType == PyTokenTypes.PERC || tokenType == PyTokenTypes.COMMA || tokenType == PyTokenTypes.SEMICOLON || "/".equals(builder.getTokenText());
    }

    @Override
    protected ParsingContext createParsingContext(PsiBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        return new PyConsoleParsingContext(builder, languageLevel, futureFlag, this.myPythonConsoleData, this.myIPythonStartSymbol);
    }
}

