/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.completion;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.PyCodeCompletionImages;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PydevConsoleReference
extends PsiPolyVariantReferenceBase<PyReferenceExpression> {
    private final ConsoleCommunication myCommunication;
    private final String myPrefix;

    public PydevConsoleReference(PyReferenceExpression expression, ConsoleCommunication communication, String prefix) {
        super((PsiElement)expression, true);
        this.myCommunication = communication;
        this.myPrefix = prefix;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = new ResolveResult[]{};
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/completion/PydevConsoleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        HashMap variants = Maps.newHashMap();
        try {
            List completions = this.myCommunication.getCompletions(this.getText(), this.myPrefix);
            for (PydevCompletionVariant completion : completions) {
                PsiManager manager = ((PyReferenceExpression)this.myElement).getManager();
                String name = completion.getName();
                int type = completion.getType();
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)new PydevConsoleElement(manager, name, completion.getDescription())).withIcon(PyCodeCompletionImages.getImageForType((int)type));
                String args = completion.getArgs();
                if (args.equals("(%)")) {
                    builder.withPresentableText("%" + completion.getName());
                    builder = builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(InsertionContext context, LookupElement item) {
                            Editor editor = context.getEditor();
                            Document document = editor.getDocument();
                            int offset = context.getStartOffset();
                            if (offset == 0 || !"%".equals(document.getText(TextRange.from((int)(offset - 1), (int)1)))) {
                                document.insertString(offset, (CharSequence)"%");
                            }
                        }
                    });
                    args = "";
                } else if (!StringUtil.isEmptyOrSpaces((String)args)) {
                    builder = builder.withTailText(args);
                }
                if (type == 2 || args.endsWith(")")) {
                    builder = builder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS);
                }
                variants.put(name, builder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = variants.values().toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/completion/PydevConsoleReference", "getVariants"));
        }
        return objectArray;
    }

    private String getText() {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyFile.class);
        if (element != null) {
            return element.getText().replace("IntellijIdeaRulezzz ", "");
        }
        return this.myPrefix;
    }
}

