/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonToolWindowConsoleRunner
extends PydevConsoleRunner {
    private ToolWindow myToolWindow;

    public PythonToolWindowConsoleRunner(@NotNull Project project, @NotNull Sdk sdk, @NotNull PyConsoleType consoleType, @Nullable String workingDir, Map<String, String> environmentVariables, String ... statementsToExecute) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PythonToolWindowConsoleRunner", "<init>"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/console/PythonToolWindowConsoleRunner", "<init>"));
        }
        if (consoleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleType", "com/jetbrains/python/console/PythonToolWindowConsoleRunner", "<init>"));
        }
        super(project, sdk, consoleType, workingDir, environmentVariables, statementsToExecute);
    }

    @Override
    public void open() {
        this.getToolWindow().activate(new Runnable(){

            @Override
            public void run() {
            }
        }, true);
    }

    public ToolWindow getToolWindow() {
        if (this.myToolWindow == null) {
            this.myToolWindow = ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow("Python Console");
        }
        return this.myToolWindow;
    }

    @Override
    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/jetbrains/python/console/PythonToolWindowConsoleRunner", "showConsole"));
        }
        PythonConsoleToolWindow consoleToolWindow = PythonConsoleToolWindow.getInstance(this.getProject());
        consoleToolWindow.init(this.getToolWindow(), contentDescriptor);
    }

    @Override
    protected void clearContent(RunContentDescriptor descriptor) {
        Content content = this.getToolWindow().getContentManager().findContent(descriptor.getDisplayName());
        assert (content != null);
        this.getToolWindow().getContentManager().removeContent(content, true);
    }

    @Override
    protected List<String> getActiveConsoleNames(final String consoleTitle) {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])PythonConsoleToolWindow.getInstance(this.getProject()).getToolWindow().getContentManager().getContents())).transform((Function)new Function<Content, String>(){

            public String apply(Content input) {
                return input.getDisplayName();
            }
        }).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(consoleTitle);
            }
        }).toList();
    }
}

