/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.wm.IdeFocusManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PythonConsoleView;
import icons.PythonIcons;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDebugLanguageConsoleView
extends DuplexConsoleView<ConsoleView, PythonConsoleView>
implements PyCodeExecutor {
    public PythonDebugLanguageConsoleView(Project project, Sdk sdk, ConsoleView consoleView) {
        super(consoleView, new PythonConsoleView(project, "Python Console", sdk));
        this.enableConsole(!PyConsoleOptions.getInstance(project).isShowDebugConsoleByDefault());
        this.getSwitchConsoleActionPresentation().setIcon(PythonIcons.Python.Debug.CommandLine);
        this.getSwitchConsoleActionPresentation().setText(PyBundle.message("run.configuration.show.command.line.action.name", new Object[0]));
    }

    public PythonDebugLanguageConsoleView(Project project, Sdk sdk) {
        this(project, sdk, TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole());
    }

    @Override
    public void executeCode(@NotNull String code, @Nullable Editor e) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/jetbrains/python/console/PythonDebugLanguageConsoleView", "executeCode"));
        }
        this.enableConsole(false);
        this.getPydevConsoleView().executeCode(code, e);
    }

    public PythonConsoleView getPydevConsoleView() {
        return (PythonConsoleView)this.getSecondaryConsoleView();
    }

    public ConsoleViewImpl getTextConsole() {
        Object consoleView = this.getPrimaryConsoleView();
        if (consoleView instanceof ConsoleViewImpl) {
            return (ConsoleViewImpl)consoleView;
        }
        return null;
    }

    @Override
    public void enableConsole(boolean primary) {
        super.enableConsole(primary);
        if (!primary && !this.isPrimaryConsoleEnabled()) {
            PythonConsoleView pydevConsoleView = this.getPydevConsoleView();
            LanguageConsoleImpl languageConsole = pydevConsoleView.getConsole();
            IdeFocusManager.findInstance().requestFocus((Component)languageConsole.getConsoleEditor().getContentComponent(), true);
            pydevConsoleView.updateUI();
            languageConsole.getHistoryViewer().getComponent().updateUI();
        }
    }
}

