/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonDebugConsoleCommunication
extends AbstractConsoleCommunication {
    private final PyDebugProcess myDebugProcess;
    private final StringBuilder myExpression = new StringBuilder();

    public PythonDebugConsoleCommunication(Project project, PyDebugProcess debugProcess) {
        super(project);
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text, String actualToken) throws Exception {
        List<PydevCompletionVariant> list = this.myDebugProcess.getCompletions(actualToken);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonDebugConsoleCommunication", "getCompletions"));
        }
        return list;
    }

    public String getDescription(String text) {
        return null;
    }

    public boolean isWaitingForInput() {
        return false;
    }

    public boolean isExecuting() {
        return false;
    }

    protected void exec(ConsoleCommunication.ConsoleCodeFragment command, final PyDebugCallback<Pair<String, Boolean>> callback) {
        this.myDebugProcess.consoleExec(command.getText(), new PyDebugCallback<String>(){

            public void ok(String value) {
                callback.ok((Object)AbstractConsoleCommunication.parseExecResponseString((String)value));
            }

            public void error(PyDebuggerException exception) {
                callback.error(exception);
            }
        });
    }

    public void execInterpreter(ConsoleCommunication.ConsoleCodeFragment code, final Function<InterpreterResponse, Object> callback) {
        this.myExpression.append(code.getText());
        this.exec(new ConsoleCommunication.ConsoleCodeFragment(this.myExpression.toString(), false), new PyDebugCallback<Pair<String, Boolean>>(){

            public void ok(Pair<String, Boolean> executed) {
                boolean more = (Boolean)executed.second;
                if (!more) {
                    PythonDebugConsoleCommunication.this.myExpression.setLength(0);
                }
                callback.fun((Object)new InterpreterResponse(more, PythonDebugConsoleCommunication.this.isWaitingForInput()));
            }

            public void error(PyDebuggerException exception) {
                PythonDebugConsoleCommunication.this.myExpression.setLength(0);
                callback.fun((Object)new InterpreterResponse(false, PythonDebugConsoleCommunication.this.isWaitingForInput()));
            }
        });
    }

    public void interrupt() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuspended() {
        return this.myDebugProcess.getSession().isSuspended();
    }
}

