/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.LanguageConsoleViewImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleIndentUtil;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleSourceHighlighter;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.completion.PythonConsoleAutopopupBlockingHandler;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleView
extends JPanel
implements LanguageConsoleView,
ObservableConsoleView,
PyCodeExecutor {
    private static final Logger LOG = Logger.getInstance(PythonConsoleView.class);
    private final Project myProject;
    private PydevConsoleExecuteActionHandler myExecuteActionHandler;
    private PyConsoleSourceHighlighter mySourceHighlighter;
    private boolean myIsIPythonOutput = false;
    private final PyHighlighter myPyHighlighter;
    private final EditorColorsScheme myScheme;
    private boolean myHyperlink;
    private final LanguageConsoleViewImpl myLanguageConsoleView;
    private Disposable mySplitDisposable;

    public PythonConsoleView(Project project, String title, Sdk sdk) {
        super(new BorderLayout());
        LanguageConsoleImpl languageConsole = new LanguageConsoleImpl(project, title, PythonLanguage.getInstance(), false);
        if (languageConsole.getFile().getVirtualFile() != null) {
            languageConsole.getFile().getVirtualFile().putUserData(LanguageLevel.KEY, (Object)PythonSdkType.getLanguageLevelForSdk(sdk));
        }
        languageConsole.getConsoleEditor().putUserData(PythonConsoleAutopopupBlockingHandler.REPL_KEY, new Object());
        languageConsole.setShowSeparatorLine(PyConsoleOptions.getInstance(project).isShowSeparatorLine());
        languageConsole.initComponents();
        this.myLanguageConsoleView = new LanguageConsoleViewImpl(languageConsole);
        Disposer.register((Disposable)this, (Disposable)this.myLanguageConsoleView);
        this.add((Component)this.myLanguageConsoleView.getComponent(), "Center");
        this.addSaveContentFocusListener(this.getLanguageConsole().getConsoleEditor().getContentComponent());
        this.getPythonLanguageConsole().setPrompt(">>> ");
        this.myLanguageConsoleView.setUpdateFoldingsEnabled(false);
        this.myProject = project;
        this.myPyHighlighter = new PyHighlighter(sdk != null && sdk.getVersionString() != null ? LanguageLevel.fromPythonVersion(sdk.getVersionString()) : LanguageLevel.getDefault());
        this.myScheme = this.getPythonLanguageConsole().getConsoleEditor().getColorsScheme();
    }

    public void setConsoleCommunication(ConsoleCommunication communication) {
        this.getPythonLanguageConsole().getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_KEY, (Object)communication);
    }

    public void setExecutionHandler(@NotNull PydevConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleExecuteActionHandler", "com/jetbrains/python/console/PythonConsoleView", "setExecutionHandler"));
        }
        this.myExecuteActionHandler = consoleExecuteActionHandler;
    }

    private void addSaveContentFocusListener(JComponent component) {
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.findInstance().requestFocus((Component)this.getPythonLanguageConsole().getConsoleEditor().getContentComponent(), true);
        this.myLanguageConsoleView.updateUI();
        this.getLanguageConsole().getHistoryViewer().getComponent().updateUI();
    }

    private LanguageConsoleImpl getPythonLanguageConsole() {
        return this.getLanguageConsole();
    }

    public LanguageConsoleImpl getLanguageConsole() {
        return this.myLanguageConsoleView.getConsole();
    }

    @Override
    public void executeCode(final @NotNull String code, final @Nullable Editor editor) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/jetbrains/python/console/PythonConsoleView", "executeCode"));
        }
        this.showConsole(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Executing code in console...", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PythonConsoleView$2$1", "run"));
                        }
                        long time = System.currentTimeMillis();
                        while (!(PythonConsoleView.this.myExecuteActionHandler.isEnabled() && PythonConsoleView.this.myExecuteActionHandler.canExecuteNow() || indicator.isCanceled())) {
                            if (System.currentTimeMillis() - time > 1000L) {
                                if (editor != null) {
                                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            HintManager.getInstance().showErrorHint(editor, PythonConsoleView.this.myExecuteActionHandler.getCantExecuteMessage());
                                        }
                                    });
                                }
                                return;
                            }
                            TimeoutUtil.sleep((long)300L);
                        }
                        if (!indicator.isCanceled()) {
                            PythonConsoleView.this.doExecute(code);
                        }
                    }
                });
            }
        });
    }

    private void showConsole(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/python/console/PythonConsoleView", "showConsole"));
        }
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(this.myProject);
        if (toolWindow != null && !toolWindow.getToolWindow().isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            toolWindow.getToolWindow().activate(runnable);
        } else {
            runnable.run();
        }
    }

    private void doExecute(String code) {
        String codeFragment = PyConsoleIndentUtil.normalize(code, this.myExecuteActionHandler.getCurrentIndentSize());
        codeFragment = codeFragment + "\n";
        this.executeInConsole(codeFragment);
    }

    public void executeInConsole(final String code) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String text = PythonConsoleView.this.getPythonLanguageConsole().getConsoleEditor().getDocument().getText();
                PythonConsoleView.this.getPythonLanguageConsole().setInputText(code);
                PythonConsoleView.this.myExecuteActionHandler.runExecuteAction(PythonConsoleView.this.myLanguageConsoleView);
                if (!StringUtil.isEmpty((String)text)) {
                    PythonConsoleView.this.getPythonLanguageConsole().setInputText(text);
                }
            }
        });
    }

    public void executeStatement(@NotNull String statement, @NotNull Key attributes) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/python/console/PythonConsoleView", "executeStatement"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/python/console/PythonConsoleView", "executeStatement"));
        }
        this.print(statement, this.outputTypeForAttributes(attributes));
        this.myExecuteActionHandler.processLine(statement, true);
    }

    public void print(String text, @NotNull Key attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/python/console/PythonConsoleView", "print"));
        }
        this.print(text, this.outputTypeForAttributes(attributes));
    }

    public void printText(String text, ConsoleViewContentType outputType) {
        this.myLanguageConsoleView.print(text, outputType);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PythonConsoleView", "print"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/jetbrains/python/console/PythonConsoleView", "print"));
        }
        this.detectIPython(text, outputType);
        if (PyConsoleUtil.detectIPythonEnd(text)) {
            this.myIsIPythonOutput = false;
            this.mySourceHighlighter = null;
        } else if (PyConsoleUtil.detectIPythonStart(text)) {
            this.myIsIPythonOutput = true;
        } else if (this.mySourceHighlighter == null || outputType == ConsoleViewContentType.ERROR_OUTPUT) {
            if (this.myHyperlink) {
                this.printHyperlink(text, outputType);
            } else {
                this.myLanguageConsoleView.print(text, outputType);
            }
            this.myHyperlink = this.detectHyperlink(text);
            if (this.mySourceHighlighter == null && this.myIsIPythonOutput && PyConsoleUtil.detectSourcePrinting(text)) {
                this.mySourceHighlighter = new PyConsoleSourceHighlighter(this, this.myScheme, this.myPyHighlighter);
            }
        } else {
            try {
                this.mySourceHighlighter.printHighlightedSource(text);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void clear() {
        this.myLanguageConsoleView.clear();
    }

    public void scrollTo(int offset) {
        this.myLanguageConsoleView.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myLanguageConsoleView.attachToProcess(processHandler);
    }

    public void setOutputPaused(boolean value) {
        this.myLanguageConsoleView.setOutputPaused(value);
    }

    public boolean isOutputPaused() {
        return this.myLanguageConsoleView.isOutputPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myLanguageConsoleView.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
        this.myLanguageConsoleView.performWhenNoDeferredOutput(runnable);
    }

    public void setHelpId(String helpId) {
        this.myLanguageConsoleView.setHelpId(helpId);
    }

    public void addMessageFilter(Filter filter) {
        this.myLanguageConsoleView.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.myLanguageConsoleView.printHyperlink(hyperlinkText, info);
    }

    public int getContentSize() {
        return this.myLanguageConsoleView.getContentSize();
    }

    public boolean canPause() {
        return this.myLanguageConsoleView.canPause();
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray = this.myLanguageConsoleView.createConsoleActions();
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonConsoleView", "createConsoleActions"));
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.myLanguageConsoleView.allowHeavyFilters();
    }

    public void detectIPython(String text, ConsoleViewContentType outputType) {
        VirtualFile file = this.getConsoleVirtualFile();
        if (file != null) {
            if (PyConsoleUtil.detectIPythonImported(text, outputType)) {
                PyConsoleUtil.markIPython(file);
            }
            if (PyConsoleUtil.detectIPythonAutomagicOn(text)) {
                PyConsoleUtil.setIPythonAutomagic(file, true);
            }
            if (PyConsoleUtil.detectIPythonAutomagicOff(text)) {
                PyConsoleUtil.setIPythonAutomagic(file, false);
            }
        }
    }

    public VirtualFile getConsoleVirtualFile() {
        return this.getLanguageConsole().getFile().getVirtualFile();
    }

    private boolean detectHyperlink(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PythonConsoleView", "detectHyperlink"));
        }
        return this.myIsIPythonOutput && text.startsWith("File:");
    }

    private void printHyperlink(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PythonConsoleView", "printHyperlink"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/jetbrains/python/console/PythonConsoleView", "printHyperlink"));
        }
        if (!StringUtil.isEmpty((String)text)) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(text.trim());
            if (vFile != null) {
                OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.myProject, vFile, -1);
                this.myLanguageConsoleView.printHyperlink(text, (HyperlinkInfo)hyperlink);
            } else {
                this.myLanguageConsoleView.print(text, contentType);
            }
        }
    }

    public ConsoleViewContentType outputTypeForAttributes(Key attributes) {
        ConsoleViewContentType outputType = attributes == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : (attributes == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.getConsoleViewType((Key)attributes));
        return outputType;
    }

    public void setSdk(Sdk sdk) {
        this.getPythonLanguageConsole().getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_SDK, (Object)sdk);
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myLanguageConsoleView.getPreferredFocusableComponent();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/python/console/PythonConsoleView", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/python/console/PythonConsoleView", "addChangeListener"));
        }
        this.myLanguageConsoleView.addChangeListener(listener, parent);
    }

    @Override
    @NotNull
    public LanguageConsoleImpl getConsole() {
        LanguageConsoleImpl languageConsoleImpl = this.myLanguageConsoleView.getConsole();
        if (languageConsoleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonConsoleView", "getConsole"));
        }
        return languageConsoleImpl;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonConsoleView", "getProject"));
        }
        return project;
    }

    public void showVariables(PydevConsoleCommunication consoleCommunication) {
        PyStackFrame stackFrame = new PyStackFrame(this.myProject, consoleCommunication, new PyStackFrameInfo("", "", "", null), null);
        final XStandaloneVariablesView view = new XStandaloneVariablesView(this.myProject, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), stackFrame);
        consoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                view.rebuildView();
            }

            public void inputRequested() {
            }
        });
        this.splitWindow(view.getPanel(), view);
    }

    private void splitWindow(JComponent component, Disposable componentDisposable) {
        this.removeAll();
        JSplitPane p = new JSplitPane(1);
        p.add((Component)this.myLanguageConsoleView.getComponent(), "left");
        this.mySplitDisposable = componentDisposable;
        p.add((Component)component, "right");
        p.setDividerLocation((int)this.getSize().getWidth() * 2 / 3);
        this.add((Component)p, "Center");
        this.validate();
        this.repaint();
    }

    public void restoreWindow() {
        this.removeAll();
        this.add((Component)this.myLanguageConsoleView.getComponent(), "Center");
        this.validate();
        this.repaint();
        if (this.mySplitDisposable != null) {
            Disposer.dispose((Disposable)this.mySplitDisposable);
            this.mySplitDisposable = null;
        }
    }
}

