/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleToolWindow {
    public static final Key<RunContentDescriptor> CONTENT_DESCRIPTOR = Key.create((String)"CONTENT_DESCRIPTOR");
    public static final Function<Content, RunContentDescriptor> CONTENT_TO_DESCRIPTOR_FUNCTION = new Function<Content, RunContentDescriptor>(){

        public RunContentDescriptor apply(@Nullable Content input) {
            return input != null ? (RunContentDescriptor)input.getUserData(CONTENT_DESCRIPTOR) : null;
        }
    };
    private final Project myProject;
    private boolean myInitialized = false;
    private ActionCallback myActivation = new ActionCallback();

    public PythonConsoleToolWindow(Project project) {
        this.myProject = project;
    }

    public static PythonConsoleToolWindow getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PythonConsoleToolWindow", "getInstance"));
        }
        return (PythonConsoleToolWindow)project.getComponent(PythonConsoleToolWindow.class);
    }

    public List<RunContentDescriptor> getConsoleContentDescriptors() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])this.getToolWindow().getContentManager().getContents())).transform(CONTENT_TO_DESCRIPTOR_FUNCTION).filter(Predicates.notNull()).toList();
    }

    public void init(@NotNull ToolWindow toolWindow, @NotNull RunContentDescriptor contentDescriptor) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/jetbrains/python/console/PythonConsoleToolWindow", "init"));
        }
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/jetbrains/python/console/PythonConsoleToolWindow", "init"));
        }
        PythonConsoleToolWindow.setContent(toolWindow, contentDescriptor);
        if (!this.myInitialized) {
            this.doInit(toolWindow);
        }
    }

    private void doInit(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/jetbrains/python/console/PythonConsoleToolWindow", "doInit"));
        }
        this.myInitialized = true;
        toolWindow.setToHideOnEmptyContent(true);
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener(new ToolWindowManagerListener(){

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/python/console/PythonConsoleToolWindow$2", "toolWindowRegistered"));
                }
            }

            @Override
            public void stateChanged() {
                boolean visible;
                ToolWindow window = PythonConsoleToolWindow.this.getToolWindow();
                if (window != null && (visible = window.isVisible()) && toolWindow.getContentManager().getContentCount() == 0) {
                    PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(PythonConsoleToolWindow.this.myProject, null);
                    runner.run();
                }
            }
        });
    }

    private static void setContent(ToolWindow toolWindow, RunContentDescriptor contentDescriptor) {
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        Content content = toolWindow.getContentManager().findContent(contentDescriptor.getDisplayName());
        if (content == null) {
            content = PythonConsoleToolWindow.createContent(contentDescriptor);
            toolWindow.getContentManager().addContent(content);
        } else {
            SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
            PythonConsoleToolWindow.resetContent(contentDescriptor, panel, content);
        }
        toolWindow.getContentManager().setSelectedContent(content);
    }

    public ToolWindow getToolWindow() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Python Console");
    }

    private static Content createContent(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/jetbrains/python/console/PythonConsoleToolWindow", "createContent"));
        }
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, contentDescriptor.getDisplayName(), false);
        content.setCloseable(true);
        PythonConsoleToolWindow.resetContent(contentDescriptor, panel, content);
        return content;
    }

    private static void resetContent(RunContentDescriptor contentDescriptor, SimpleToolWindowPanel panel, Content content) {
        panel.setContent(contentDescriptor.getComponent());
        content.setComponent((JComponent)panel);
        content.setPreferredFocusableComponent(contentDescriptor.getComponent());
        content.putUserData(CONTENT_DESCRIPTOR, (Object)contentDescriptor);
    }

    private static FocusListener createFocusListener(final ToolWindow toolWindow) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = PythonConsoleToolWindow.getComponentToFocus(toolWindow);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private static JComponent getComponentToFocus(ToolWindow window) {
        return window.getContentManager().getComponent();
    }

    public void initialized() {
        this.myActivation.setDone();
    }

    public void activate(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/python/console/PythonConsoleToolWindow", "activate"));
        }
        this.myActivation.doWhenDone(runnable);
        this.getToolWindow().activate(null);
    }

    @Nullable
    public RunContentDescriptor getSelectedContentDescriptor() {
        return (RunContentDescriptor)CONTENT_TO_DESCRIPTOR_FUNCTION.apply((Object)this.getToolWindow().getContentManager().getSelectedContent());
    }
}

