/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.Nullable;

public class PydevDocumentationProvider
extends AbstractDocumentationProvider {
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof PydevConsoleElement) {
            return (PydevConsoleElement)object;
        }
        return super.getDocumentationElementForLookupItem(psiManager, object, element);
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof PydevConsoleElement) {
            return PydevConsoleElement.generateDoc((PydevConsoleElement)element);
        }
        return null;
    }

    @Nullable
    public static String createDoc(PsiElement element, PsiElement originalElement) {
        PyExpression expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyExpression.class);
        if (expression == null) {
            return null;
        }
        ConsoleCommunication communication = PydevConsoleRunner.getConsoleCommunication(originalElement);
        if (communication == null) {
            return null;
        }
        try {
            String description = communication.getDescription(expression.getText());
            return StringUtil.isEmptyOrSpaces((String)description) ? null : description;
        }
        catch (Exception e) {
            return null;
        }
    }
}

