/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.run.PythonCommandLineState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    @Override
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        String[] setupFragment;
        String customStartScript;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PydevConsoleRunnerFactory", "createConsoleRunner"));
        }
        Pair<Sdk, Module> sdkAndModule = PydevConsoleRunner.findPythonSdkAndModule(project, contextModule);
        Module module = (Module)sdkAndModule.second;
        Sdk sdk = (Sdk)sdkAndModule.first;
        assert (sdk != null);
        PathMappingSettings mappingSettings = PydevConsoleRunner.getMappings(project, sdk);
        PyConsoleOptions.PyConsoleSettings settingsProvider = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        List pythonPath = PythonCommandLineState.collectPythonPath(module, settingsProvider.addContentRoots(), settingsProvider.addSourceRoots());
        if (mappingSettings != null) {
            pythonPath = mappingSettings.convertToRemote(pythonPath);
        }
        String string = customStartScript = settingsProvider == null ? "" : settingsProvider.getCustomStartScript();
        if (customStartScript.trim().length() > 0) {
            customStartScript = "\n" + customStartScript;
        }
        String selfPathAppend = PydevConsoleRunner.constructPythonPathCommand(pythonPath, customStartScript);
        String workingDir = settingsProvider.getWorkingDirectory();
        if (StringUtil.isEmpty((String)workingDir)) {
            VirtualFile[] roots;
            if (module != null && ModuleRootManager.getInstance((Module)module).getContentRoots().length > 0) {
                workingDir = ModuleRootManager.getInstance((Module)module).getContentRoots()[0].getPath();
            } else if (ModuleManager.getInstance((Project)project).getModules().length > 0 && (roots = ModuleRootManager.getInstance((Module)ModuleManager.getInstance((Project)project).getModules()[0]).getContentRoots()).length > 0) {
                workingDir = roots[0].getPath();
            }
        }
        if (mappingSettings != null) {
            workingDir = mappingSettings.convertToRemote(workingDir);
        }
        BuildoutFacet facet = null;
        if (module != null) {
            facet = BuildoutFacet.getInstance(module);
        }
        if (facet != null) {
            List path = facet.getAdditionalPythonPath();
            if (mappingSettings != null) {
                path = mappingSettings.convertToRemote(path);
            }
            String prependStatement = facet.getPathPrependStatement(path);
            setupFragment = new String[]{prependStatement, selfPathAppend};
        } else {
            setupFragment = new String[]{selfPathAppend};
        }
        HashMap envs = Maps.newHashMap(settingsProvider.getEnvs());
        String ipythonEnabled = PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False";
        envs.put("IPYTHONENABLE", ipythonEnabled);
        return this.createConsoleRunner(project, sdk, workingDir, envs, PyConsoleType.PYTHON, setupFragment);
    }

    protected PydevConsoleRunner createConsoleRunner(Project project, Sdk sdk, String workingDir, Map<String, String> envs, PyConsoleType consoleType, String ... setupFragment) {
        return new PydevConsoleRunner(project, sdk, consoleType, workingDir, envs, setupFragment);
    }
}

