/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.CommandLineArgumentsProvider;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyConsoleDebugProcess;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevRemoteConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.ProcessRunner;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunner
extends AbstractConsoleRunnerWithHistory<PythonConsoleView> {
    public static final String WORKING_DIR_ENV = "WORKING_DIR_AND_PYTHON_PATHS";
    public static final String CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
    private static final Logger LOG = Logger.getInstance((String)PydevConsoleRunner.class.getName());
    public static final String PYDEV_PYDEVCONSOLE_PY = "pydev/pydevconsole.py";
    public static final int PORTS_WAITING_TIMEOUT = 20000;
    private Sdk mySdk;
    @NotNull
    private CommandLineArgumentsProvider myCommandLineArgumentsProvider;
    protected int[] myPorts;
    private PydevConsoleCommunication myPydevConsoleCommunication;
    private PyConsoleProcessHandler myProcessHandler;
    protected PydevConsoleExecuteActionHandler myConsoleExecuteActionHandler;
    private List<ConsoleListener> myConsoleListeners;
    private final PyConsoleType myConsoleType;
    private Map<String, String> myEnvironmentVariables;
    private String myCommandLine;
    private String[] myStatementsToExecute;
    private ConsoleHistoryController myHistoryController;
    public static Key<ConsoleCommunication> CONSOLE_KEY = new Key("PYDEV_CONSOLE_KEY");
    public static Key<Sdk> CONSOLE_SDK = new Key("PYDEV_CONSOLE_SDK_KEY");
    private static final long APPROPRIATE_TO_WAIT = 60000L;
    private PyRemoteSdkCredentials myRemoteCredentials;
    private String myConsoleTitle;

    public PydevConsoleRunner(@NotNull Project project, @NotNull Sdk sdk, @NotNull PyConsoleType consoleType, @Nullable String workingDir, Map<String, String> environmentVariables, String ... statementsToExecute) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PydevConsoleRunner", "<init>"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/console/PydevConsoleRunner", "<init>"));
        }
        if (consoleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleType", "com/jetbrains/python/console/PydevConsoleRunner", "<init>"));
        }
        super(project, consoleType.getTitle(), workingDir);
        this.myConsoleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myStatementsToExecute = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myConsoleTitle = null;
        this.mySdk = sdk;
        this.myConsoleType = consoleType;
        this.myEnvironmentVariables = environmentVariables;
        this.myStatementsToExecute = statementsToExecute;
    }

    public static PathMappingSettings getMappings(Project project, Sdk sdk) {
        PythonRemoteInterpreterManager instance;
        PathMappingSettings mappingSettings = null;
        if (PySdkUtil.isRemote(sdk) && (instance = PythonRemoteInterpreterManager.getInstance()) != null) {
            mappingSettings = instance.setupMappings(project, (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData(), null);
        }
        return mappingSettings;
    }

    @NotNull
    public static Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PydevConsoleRunner", "findPythonSdkAndModule"));
        }
        Sdk sdk = null;
        Module module = null;
        PyConsoleOptions.PyConsoleSettings settings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        String sdkHome = settings.getSdkHome();
        if (sdkHome != null) {
            sdk = PythonSdkType.findSdkByPath(sdkHome);
            if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            } else {
                module = contextModule;
                if (module == null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
                    module = ModuleManager.getInstance((Project)project).getModules()[0];
                }
            }
        }
        if (sdk == null && settings.isUseModuleSdk()) {
            if (contextModule != null) {
                module = contextModule;
            } else if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            }
            if (module != null && PythonSdkType.findPythonSdk(module) != null) {
                sdk = PythonSdkType.findPythonSdk(module);
            }
        } else if (contextModule != null) {
            if (module == null) {
                module = contextModule;
            }
            if (sdk == null) {
                sdk = PythonSdkType.findPythonSdk(module);
            }
        }
        if (sdk == null) {
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (PythonSdkType.findPythonSdk(m) == null) continue;
                sdk = PythonSdkType.findPythonSdk(m);
                module = m;
                break;
            }
        }
        if (sdk == null && PythonSdkType.getAllSdks().size() > 0) {
            sdk = PythonSdkType.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk, (Object)module);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleRunner", "findPythonSdkAndModule"));
        }
        return pair;
    }

    public static String constructPythonPathCommand(Collection<String> pythonPath, String command) {
        String path = Joiner.on((String)", ").join((Iterable)Collections2.transform(pythonPath, (Function)new Function<String, String>(){

            public String apply(String input) {
                return "'" + input.replace("\\", "\\\\").replace("'", "\\'") + "'";
            }
        }));
        return command.replace(WORKING_DIR_ENV, path);
    }

    public void setStatementsToExecute(String ... statementsToExecute) {
        this.myStatementsToExecute = statementsToExecute;
    }

    public static Map<String, String> addDefaultEnvironments(Sdk sdk, Map<String, String> envs) {
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        String encoding = defaultCharset != null ? defaultCharset.name() : "utf-8";
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), encoding);
        PythonSdkFlavor.initPythonPath(envs, true, PythonCommandLineState.getAddedPaths(sdk));
        return envs;
    }

    @Override
    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        AnAction backspaceHandlingAction = this.createBackspaceHandlingAction();
        AnAction interruptAction = this.createInterruptAction();
        AnAction rerunAction = this.createRerunAction();
        toolbarActions.add(rerunAction);
        List<AnAction> actions = super.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        actions.add(0, rerunAction);
        actions.add(backspaceHandlingAction);
        actions.add(interruptAction);
        actions.add(this.createSplitLineAction());
        ShowVarsAction showVarsAction = new ShowVarsAction();
        toolbarActions.add((AnAction)showVarsAction);
        toolbarActions.add(this.myHistoryController.getBrowseHistory());
        toolbarActions.add((AnAction)new ConnectDebuggerAction());
        toolbarActions.add((AnAction)new NewConsoleAction());
        return actions;
    }

    public void runSync() {
        this.myPorts = PydevConsoleRunner.findAvailablePorts(this.getProject(), this.myConsoleType);
        assert (this.myPorts != null);
        this.myCommandLineArgumentsProvider = this.createCommandLineArgumentsProvider(this.mySdk, this.myEnvironmentVariables, this.myPorts);
        try {
            super.initAndRun();
        }
        catch (ExecutionException e) {
            LOG.warn("Error running console", (Throwable)e);
            ExecutionHelper.showErrors(this.getProject(), Arrays.asList(new Exception[]{e}), "Python Console", null);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), "Connecting to console", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunner$2", "run"));
                }
                indicator.setText("Connecting to console...");
                PydevConsoleRunner.this.connect(PydevConsoleRunner.this.myStatementsToExecute);
            }
        });
    }

    public void open() {
        this.run();
    }

    public void createNewConsole() {
        this.run();
    }

    public void run() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        this.myPorts = PydevConsoleRunner.findAvailablePorts(this.getProject(), this.myConsoleType);
        assert (this.myPorts != null);
        this.myCommandLineArgumentsProvider = this.createCommandLineArgumentsProvider(this.mySdk, this.myEnvironmentVariables, this.myPorts);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(PydevConsoleRunner.this.getProject(), "Connecting to console", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunner$4$1", "run"));
                        }
                        indicator.setText("Connecting to console...");
                        try {
                            PydevConsoleRunner.this.initAndRun(PydevConsoleRunner.this.myStatementsToExecute);
                        }
                        catch (ExecutionException e) {
                            LOG.warn("Error running console", (Throwable)e);
                            assert (this.myProject != null);
                            ExecutionHelper.showErrors(this.myProject, Arrays.asList(new Exception[]{e}), this.getTitle(), null);
                        }
                    }
                });
            }
        });
    }

    public static PydevConsoleRunner create(Project project, Sdk sdk, PyConsoleType consoleType, String workingDirectory) {
        return new PydevConsoleRunner(project, sdk, consoleType, workingDirectory, Maps.newHashMap(), new String[0]);
    }

    private static int[] findAvailablePorts(Project project, PyConsoleType consoleType) {
        int[] ports;
        try {
            ports = NetUtils.findAvailableSocketPorts((int)2);
        }
        catch (IOException e) {
            ExecutionHelper.showErrors(project, Arrays.asList(e), consoleType.getTitle(), null);
            return null;
        }
        return ports;
    }

    protected CommandLineArgumentsProvider createCommandLineArgumentsProvider(final Sdk sdk, final Map<String, String> environmentVariables, int[] ports) {
        final ArrayList<String> args = new ArrayList<String>();
        args.add(sdk.getHomePath());
        String versionString = sdk.getVersionString();
        if (versionString == null || !versionString.toLowerCase().contains("jython")) {
            args.add("-u");
        }
        args.add(FileUtil.toSystemDependentName((String)PythonHelpersLocator.getHelperPath(PYDEV_PYDEVCONSOLE_PY)));
        for (int port : ports) {
            args.add(String.valueOf(port));
        }
        return new CommandLineArgumentsProvider(){

            public String[] getArguments() {
                return ArrayUtil.toStringArray((Collection)args);
            }

            public boolean passParentEnvs() {
                return false;
            }

            public Map<String, String> getAdditionalEnvs() {
                return PydevConsoleRunner.addDefaultEnvironments(sdk, environmentVariables);
            }
        };
    }

    @Override
    protected PythonConsoleView createConsoleView() {
        PythonConsoleView consoleView = new PythonConsoleView(this.getProject(), this.getConsoleTitle(), this.mySdk);
        this.myPydevConsoleCommunication.setConsoleFile(consoleView.getConsoleVirtualFile());
        consoleView.addMessageFilter(new PythonTracebackFilter(this.getProject()));
        return consoleView;
    }

    @Override
    protected Process createProcess() throws ExecutionException {
        if (PySdkUtil.isRemote(this.mySdk)) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                return this.createRemoteConsoleProcess(manager, this.myCommandLineArgumentsProvider.getArguments(), this.myCommandLineArgumentsProvider.getAdditionalEnvs());
            }
            throw new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
        }
        this.myCommandLine = this.myCommandLineArgumentsProvider.getCommandLineString();
        Map envs = this.myCommandLineArgumentsProvider.getAdditionalEnvs();
        if (envs != null) {
            EncodingEnvironmentUtil.fixDefaultEncodingIfMac((Map)envs, (Project)this.getProject());
        }
        Process server = ProcessRunner.createProcess(this.getWorkingDir(), envs, this.myCommandLineArgumentsProvider.getArguments());
        try {
            this.myPydevConsoleCommunication = new PydevConsoleCommunication(this.getProject(), this.myPorts[0], server, this.myPorts[1]);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage());
        }
        return server;
    }

    private Process createRemoteConsoleProcess(PythonRemoteInterpreterManager manager, String[] command, Map<String, String> env) throws ExecutionException {
        PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
        assert (data != null);
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        commandLine.getEnvironment().putAll(env);
        commandLine.getParametersList().set(1, PythonRemoteInterpreterManager.toSystemDependent(new File(data.getHelpersPath(), PYDEV_PYDEVCONSOLE_PY).getPath(), PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        commandLine.getParametersList().set(2, "0");
        commandLine.getParametersList().set(3, "0");
        this.myCommandLine = commandLine.getCommandLineString();
        try {
            this.myRemoteCredentials = (PyRemoteSdkCredentials)data.getRemoteSdkCredentials(true);
            PathMappingSettings mappings = manager.setupMappings(this.getProject(), data, null);
            RemoteSshProcess remoteProcess = manager.createRemoteProcess(this.getProject(), this.myRemoteCredentials, mappings, commandLine, true);
            Couple<Integer> remotePorts = PydevConsoleRunner.getRemotePortsFromProcess(remoteProcess);
            remoteProcess.addLocalTunnel(this.myPorts[0], this.myRemoteCredentials.getHost(), (Integer)remotePorts.first);
            remoteProcess.addRemoteTunnel((Integer)remotePorts.second, "localhost", this.myPorts[1]);
            this.myPydevConsoleCommunication = new PydevRemoteConsoleCommunication(this.getProject(), this.myPorts[0], remoteProcess, this.myPorts[1]);
            return remoteProcess;
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    private static Couple<Integer> getRemotePortsFromProcess(RemoteSshProcess process) throws ExecutionException {
        Scanner s = new Scanner(process.getInputStream());
        return Couple.of((Object)PydevConsoleRunner.readInt(s, process), (Object)PydevConsoleRunner.readInt(s, process));
    }

    private static int readInt(Scanner s, Process process) throws ExecutionException {
        long started = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() - started < 20000L) {
            String error;
            if (s.hasNextLine()) {
                String line = s.nextLine();
                sb.append(line).append("\n");
                try {
                    int i = Integer.parseInt(line);
                    if (flag) {
                        LOG.warn("Unexpected strings in output:\n" + sb.toString());
                    }
                    return i;
                }
                catch (NumberFormatException ignored) {
                    flag = true;
                    continue;
                }
            }
            TimeoutUtil.sleep((long)200L);
            if (process.exitValue() == 0) break;
            try {
                error = "Console process terminated with error:\n" + StreamUtil.readText((InputStream)process.getErrorStream()) + sb.toString();
            }
            catch (Exception ignored) {
                error = "Console process terminated with exit code " + process.exitValue() + ", output:" + sb.toString();
            }
            throw new ExecutionException(error);
        }
        throw new ExecutionException("Couldn't read integer value from stream");
    }

    protected PyConsoleProcessHandler createProcessHandler(Process process) {
        if (PySdkUtil.isRemote(this.mySdk)) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
                assert (data != null);
                this.myProcessHandler = manager.createConsoleProcessHandler(process, this.myRemoteCredentials, (PythonConsoleView)this.getConsoleView(), this.myPydevConsoleCommunication, this.myCommandLine, CharsetToolkit.UTF8_CHARSET, manager.setupMappings(this.getProject(), data, null));
            } else {
                LOG.error("Can't create remote console process handler");
            }
        } else {
            this.myProcessHandler = new PyConsoleProcessHandler(process, (PythonConsoleView)this.getConsoleView(), this.myPydevConsoleCommunication, this.myCommandLine, CharsetToolkit.UTF8_CHARSET);
        }
        return this.myProcessHandler;
    }

    public void initAndRun(String ... statements2execute) throws ExecutionException {
        super.initAndRun();
        this.connect(statements2execute);
    }

    public void connect(final String[] statements2execute) {
        if (this.handshake()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    final PythonConsoleView consoleView = (PythonConsoleView)PydevConsoleRunner.this.getConsoleView();
                    consoleView.setConsoleCommunication((ConsoleCommunication)PydevConsoleRunner.this.myPydevConsoleCommunication);
                    consoleView.setSdk(PydevConsoleRunner.this.mySdk);
                    consoleView.setExecutionHandler(PydevConsoleRunner.this.myConsoleExecuteActionHandler);
                    PydevConsoleRunner.this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(ProcessEvent event, Key outputType) {
                            consoleView.print(event.getText(), outputType);
                        }
                    });
                    PydevConsoleRunner.this.enableConsoleExecuteAction();
                    for (String statement : statements2execute) {
                        consoleView.executeStatement(statement + "\n", ProcessOutputTypes.SYSTEM);
                    }
                    PydevConsoleRunner.this.fireConsoleInitializedEvent(consoleView);
                }
            });
        } else {
            ((PythonConsoleView)this.getConsoleView()).print("Couldn't connect to console process.", ProcessOutputTypes.STDERR);
            this.myProcessHandler.destroyProcess();
            this.finishConsole();
        }
    }

    @Override
    protected String constructConsoleTitle(@NotNull String consoleTitle) {
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/jetbrains/python/console/PydevConsoleRunner", "constructConsoleTitle"));
        }
        if (this.myConsoleTitle == null) {
            this.myConsoleTitle = super.constructConsoleTitle(consoleTitle);
        }
        return this.myConsoleTitle;
    }

    protected AnAction createRerunAction() {
        return new RestartAction(this);
    }

    private AnAction createInterruptAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (PydevConsoleRunner.this.myPydevConsoleCommunication.isExecuting()) {
                    ((PythonConsoleView)PydevConsoleRunner.this.getConsoleView()).print("^C", ProcessOutputTypes.SYSTEM);
                }
                PydevConsoleRunner.this.myPydevConsoleCommunication.interrupt();
            }

            public void update(AnActionEvent e) {
                EditorEx consoleEditor = ((PythonConsoleView)PydevConsoleRunner.this.getConsoleView()).getConsole().getConsoleEditor();
                boolean enabled = IJSwingUtilities.hasFocus(consoleEditor.getComponent()) && !consoleEditor.getSelectionModel().hasSelection();
                e.getPresentation().setEnabled(enabled);
            }
        };
        anAction.registerCustomShortcutSet(67, 2, ((PythonConsoleView)this.getConsoleView()).getConsole().getConsoleEditor().getComponent());
        anAction.getTemplatePresentation().setVisible(false);
        return anAction;
    }

    private AnAction createBackspaceHandlingAction() {
        AnAction upAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                new WriteCommandAction(PydevConsoleRunner.this.getLanguageConsole().getProject(), new PsiFile[]{PydevConsoleRunner.this.getLanguageConsole().getFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/console/PydevConsoleRunner$8$1", "run"));
                        }
                        String text = PydevConsoleRunner.this.getLanguageConsole().getEditorDocument().getText();
                        String newText = text.substring(0, text.length() - PydevConsoleRunner.this.myConsoleExecuteActionHandler.getPythonIndent());
                        PydevConsoleRunner.this.getLanguageConsole().getEditorDocument().setText((CharSequence)newText);
                        PydevConsoleRunner.this.getLanguageConsole().getConsoleEditor().getCaretModel().moveToOffset(newText.length());
                    }
                }.execute();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(PydevConsoleRunner.this.myConsoleExecuteActionHandler.getCurrentIndentSize() >= PydevConsoleRunner.this.myConsoleExecuteActionHandler.getPythonIndent() && PydevConsoleRunner.this.isIndentSubstring(PydevConsoleRunner.this.getLanguageConsole().getEditorDocument().getText()));
            }
        };
        upAction.registerCustomShortcutSet(8, 0, null);
        upAction.getTemplatePresentation().setVisible(false);
        return upAction;
    }

    private boolean isIndentSubstring(String text) {
        int indentSize = this.myConsoleExecuteActionHandler.getPythonIndent();
        return text.length() >= indentSize && CharMatcher.WHITESPACE.matchesAllOf((CharSequence)text.substring(text.length() - indentSize));
    }

    private void enableConsoleExecuteAction() {
        this.myConsoleExecuteActionHandler.setEnabled(true);
    }

    private boolean handshake() {
        boolean res;
        long started = System.currentTimeMillis();
        while (true) {
            long now;
            try {
                res = this.myPydevConsoleCommunication.handshake();
            }
            catch (XmlRpcException ignored) {
                res = false;
            }
            if (res || (now = System.currentTimeMillis()) - started > 60000L) break;
            TimeoutUtil.sleep((long)100L);
        }
        return res;
    }

    @Override
    protected AnAction createStopAction() {
        AnAction generalStopAction = super.createStopAction();
        return this.createConsoleStoppingAction(generalStopAction);
    }

    @Override
    protected AnAction createCloseAction(Executor defaultExecutor, final RunContentDescriptor descriptor) {
        final AnAction generalCloseAction = super.createCloseAction(defaultExecutor, descriptor);
        DumbAwareAction stopAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                generalCloseAction.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                e = PydevConsoleRunner.this.stopConsole(e);
                PydevConsoleRunner.this.clearContent(descriptor);
                generalCloseAction.actionPerformed(e);
            }
        };
        stopAction.copyFrom(generalCloseAction);
        return stopAction;
    }

    protected void clearContent(RunContentDescriptor descriptor) {
    }

    private AnAction createConsoleStoppingAction(final AnAction generalStopAction) {
        DumbAwareAction stopAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                generalStopAction.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                e = PydevConsoleRunner.this.stopConsole(e);
                generalStopAction.actionPerformed(e);
            }
        };
        stopAction.copyFrom(generalStopAction);
        return stopAction;
    }

    private AnActionEvent stopConsole(AnActionEvent e) {
        if (this.myPydevConsoleCommunication != null) {
            e = new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            try {
                this.closeCommunication();
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return e;
    }

    protected AnAction createSplitLineAction() {
        class ConsoleSplitLineAction
        extends EditorAction {
            private static final String CONSOLE_SPLIT_LINE_ACTION_ID = "Console.SplitLine";

            public ConsoleSplitLineAction() {
                super((EditorActionHandler)new EditorWriteActionHandler(){
                    private final SplitLineAction mySplitLineAction = new SplitLineAction();

                    public boolean isEnabled(Editor editor, DataContext dataContext) {
                        return this.mySplitLineAction.getHandler().isEnabled(editor, dataContext);
                    }

                    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
                        ((EditorWriteActionHandler)this.mySplitLineAction.getHandler()).executeWriteAction(editor, caret, dataContext);
                        editor.getCaretModel().getCurrentCaret().moveCaretRelatively(0, 1, false, true);
                    }
                });
            }

            public void setup() {
                EmptyAction.setupAction((AnAction)this, (String)CONSOLE_SPLIT_LINE_ACTION_ID, null);
            }
        }
        ConsoleSplitLineAction action = new ConsoleSplitLineAction();
        action.setup();
        return action;
    }

    private void closeCommunication() {
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myPydevConsoleCommunication.close();
        }
    }

    @Override
    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        this.myConsoleExecuteActionHandler = new PydevConsoleExecuteActionHandler((LanguageConsoleView)this.getConsoleView(), this.getProcessHandler(), (ConsoleCommunication)this.myPydevConsoleCommunication);
        this.myConsoleExecuteActionHandler.setEnabled(false);
        this.myHistoryController = new ConsoleHistoryController(this.myConsoleType.getTypeId(), "", this.getLanguageConsole(), this.myConsoleExecuteActionHandler.getConsoleHistoryModel());
        this.myHistoryController.install();
        PydevConsoleExecuteActionHandler pydevConsoleExecuteActionHandler = this.myConsoleExecuteActionHandler;
        if (pydevConsoleExecuteActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleRunner", "createExecuteActionHandler"));
        }
        return pydevConsoleExecuteActionHandler;
    }

    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.myPydevConsoleCommunication;
    }

    public static boolean isInPydevConsole(PsiElement element) {
        return element instanceof PydevConsoleElement || PydevConsoleRunner.getConsoleCommunication(element) != null;
    }

    public static boolean isInPydevConsole(VirtualFile file) {
        return file.getName().contains("Python Console");
    }

    public static boolean isPythonConsole(@Nullable FileElement element) {
        return PydevConsoleRunner.getPythonConsoleData(element) != null;
    }

    @Nullable
    public static PythonConsoleData getPythonConsoleData(@Nullable FileElement element) {
        if (element == null || element.getPsi() == null || element.getPsi().getContainingFile() == null) {
            return null;
        }
        VirtualFile file = PydevConsoleRunner.getConsoleFile(element.getPsi().getContainingFile());
        if (file == null) {
            return null;
        }
        return (PythonConsoleData)file.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    private static VirtualFile getConsoleFile(PsiFile psiFile) {
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        return file;
    }

    @Nullable
    public static ConsoleCommunication getConsoleCommunication(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile != null ? (ConsoleCommunication)containingFile.getCopyableUserData(CONSOLE_KEY) : null;
    }

    @Nullable
    public static Sdk getConsoleSdk(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile != null ? (Sdk)containingFile.getCopyableUserData(CONSOLE_SDK) : null;
    }

    @Override
    protected boolean shouldAddNumberToTitle() {
        return true;
    }

    public void addConsoleListener(ConsoleListener consoleListener) {
        this.myConsoleListeners.add(consoleListener);
    }

    public void removeConsoleListener(ConsoleListener consoleListener) {
        this.myConsoleListeners.remove(consoleListener);
    }

    private void fireConsoleInitializedEvent(LanguageConsoleView consoleView) {
        for (ConsoleListener listener : this.myConsoleListeners) {
            listener.handleConsoleInitialized(consoleView);
        }
    }

    private void rerun() {
        new Task.Backgroundable(this.getProject(), "Restarting console", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunner$11", "run"));
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PydevConsoleRunner.this.closeCommunication();
                    }
                });
                PydevConsoleRunner.this.myProcessHandler.waitFor();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PydevConsoleRunner.this.run();
                    }
                });
            }
        }.queue();
    }

    private XDebugSession connectToDebugger() throws ExecutionException {
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        XDebugSession session = XDebuggerManager.getInstance((Project)this.getProject()).startSessionAndShowTab("Python Console Debugger", PythonIcons.Python.Python, null, true, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/console/PydevConsoleRunner$12", "start"));
                }
                PythonDebugLanguageConsoleView debugConsoleView = new PythonDebugLanguageConsoleView(PydevConsoleRunner.this.getProject(), PydevConsoleRunner.this.mySdk);
                PyConsoleDebugProcessHandler consoleDebugProcessHandler = new PyConsoleDebugProcessHandler(PydevConsoleRunner.this.myProcessHandler);
                PyConsoleDebugProcess consoleDebugProcess = new PyConsoleDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, consoleDebugProcessHandler);
                PythonDebugConsoleCommunication communication = PyDebugRunner.initDebugConsoleView(PydevConsoleRunner.this.getProject(), consoleDebugProcess, debugConsoleView, consoleDebugProcessHandler, session);
                communication.addCommunicationListener(new ConsoleCommunicationListener(){

                    public void commandExecuted(boolean more) {
                        session.rebuildViews();
                    }

                    public void inputRequested() {
                    }
                });
                PydevConsoleRunner.this.myPydevConsoleCommunication.setDebugCommunication(communication);
                debugConsoleView.attachToProcess(consoleDebugProcessHandler);
                consoleDebugProcess.waitForNextConnection();
                try {
                    consoleDebugProcess.connect(PydevConsoleRunner.this.myPydevConsoleCommunication);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                PydevConsoleRunner.this.myProcessHandler.notifyTextAvailable("\nDebugger connected.\n", ProcessOutputTypes.STDERR);
                PyConsoleDebugProcess pyConsoleDebugProcess = consoleDebugProcess;
                if (pyConsoleDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleRunner$12", "start"));
                }
                return pyConsoleDebugProcess;
            }
        });
        return session;
    }

    public static PythonConsoleRunnerFactory factory() {
        return new PydevConsoleRunnerFactory();
    }

    private static class NewConsoleAction
    extends AnAction
    implements DumbAware {
        public NewConsoleAction() {
            super("New Console", "Creates new python console", AllIcons.General.Add);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner((Project)e.getData(CommonDataKeys.PROJECT), (Module)e.getData(LangDataKeys.MODULE));
            runner.createNewConsole();
        }
    }

    private class ConnectDebuggerAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private XDebugSession mySession;

        public ConnectDebuggerAction() {
            super("Attach Debugger", "Enables tracing of code executed in console", AllIcons.Actions.StartDebugger);
            this.mySelected = false;
            this.mySession = null;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void update(AnActionEvent e) {
            if (this.mySession != null) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(true);
            }
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.mySelected = state2;
            if (this.mySelected) {
                try {
                    this.mySession = PydevConsoleRunner.this.connectToDebugger();
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                    Messages.showErrorDialog((String)"Can't connect to debugger", (String)"Error Connecting Debugger");
                }
            }
        }
    }

    private class ShowVarsAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;

        public ShowVarsAction() {
            super("Show Variables", "Shows active console variables", AllIcons.Debugger.Watches);
            this.mySelected = false;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.mySelected = state2;
            if (this.mySelected) {
                ((PythonConsoleView)PydevConsoleRunner.this.getConsoleView()).showVariables(PydevConsoleRunner.this.myPydevConsoleCommunication);
            } else {
                ((PythonConsoleView)PydevConsoleRunner.this.getConsoleView()).restoreWindow();
            }
        }
    }

    private static class RestartAction
    extends AnAction {
        private PydevConsoleRunner myConsoleRunner;

        private RestartAction(PydevConsoleRunner runner) {
            this.copyFrom(ActionManager.getInstance().getAction("Rerun"));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Restart);
            this.myConsoleRunner = runner;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myConsoleRunner.rerun();
        }
    }

    public static interface ConsoleListener {
        public void handleConsoleInitialized(LanguageConsoleView var1);
    }
}

