/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.console.PyConsoleIndentUtil;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleExecuteActionHandler
extends ProcessBackedConsoleExecuteActionHandler
implements ConsoleCommunicationListener {
    private final LanguageConsoleView myConsoleView;
    private String myInMultilineStringState = null;
    private StringBuilder myInputBuffer;
    private int myCurrentIndentSize = 0;
    private final ConsoleCommunication myConsoleCommunication;
    private boolean myEnabled = false;
    private int myIpythonInputPromptCount = 1;

    public PydevConsoleExecuteActionHandler(LanguageConsoleView consoleView, ProcessHandler processHandler, ConsoleCommunication consoleCommunication) {
        super(processHandler, false);
        this.myConsoleView = consoleView;
        this.myConsoleCommunication = consoleCommunication;
        this.myConsoleCommunication.addCommunicationListener((ConsoleCommunicationListener)this);
    }

    @Override
    public void processLine(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "processLine"));
        }
        this.processLine(text, false);
    }

    public void processLine(@NotNull String text, boolean execAnyway) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "processLine"));
        }
        int indentBefore = this.myCurrentIndentSize;
        if (text.isEmpty()) {
            this.processOneLine(text);
        } else if (StringUtil.countNewLines((CharSequence)text.trim()) > 0) {
            this.executeMultiLine(text);
        } else {
            this.processOneLine(text);
        }
        if (execAnyway && this.myCurrentIndentSize > 0 && indentBefore == 0) {
            this.finishExecution();
        }
    }

    private void executeMultiLine(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "executeMultiLine"));
        }
        if (this.myInputBuffer == null) {
            this.myInputBuffer = new StringBuilder();
        }
        this.myInputBuffer.append(text);
        LanguageConsoleImpl console = this.myConsoleView.getConsole();
        EditorEx currentEditor = console.getConsoleEditor();
        this.sendLineToConsole(new ConsoleCommunication.ConsoleCodeFragment(this.myInputBuffer.toString(), false), console, currentEditor);
    }

    private void processOneLine(String line) {
        int indentSize = IndentHelperImpl.getIndent(this.getProject(), (FileType)PythonFileType.INSTANCE, line, false);
        if (StringUtil.isEmptyOrSpaces((String)(line = StringUtil.trimTrailing((String)line)))) {
            this.doProcessLine("\n");
        } else if (indentSize == 0 && indentSize < this.myCurrentIndentSize && !PyConsoleIndentUtil.shouldIndent(line) && !this.myConsoleCommunication.isWaitingForInput()) {
            this.doProcessLine("\n");
            this.doProcessLine(line);
        } else {
            this.doProcessLine(line);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doProcessLine(String line) {
        EditorEx currentEditor;
        LanguageConsoleImpl console;
        block16: {
            console = this.myConsoleView.getConsole();
            currentEditor = console.getConsoleEditor();
            if (this.myInputBuffer == null) {
                this.myInputBuffer = new StringBuilder();
            }
            if (!StringUtil.isEmptyOrSpaces((String)line)) {
                this.myInputBuffer.append(line);
                if (!line.endsWith("\n")) {
                    this.myInputBuffer.append("\n");
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)line) && StringUtil.isEmptyOrSpaces((String)this.myInputBuffer.toString())) {
                this.myInputBuffer.append("");
            }
            if (this.myInMultilineStringState != null) {
                if (PyConsoleUtil.isDoubleQuoteMultilineStarts(line) || PyConsoleUtil.isSingleQuoteMultilineStarts(line)) {
                    this.myInMultilineStringState = null;
                    console.setLanguage(PythonLanguage.getInstance());
                    console.setPrompt(">>> ");
                    break block16;
                } else {
                    if (line.equals("\n")) {
                        this.myInputBuffer.append("\n");
                    }
                    return;
                }
            }
            if (PyConsoleUtil.isDoubleQuoteMultilineStarts(line)) {
                this.myInMultilineStringState = "\"\"\"";
            } else if (PyConsoleUtil.isSingleQuoteMultilineStarts(line)) {
                this.myInMultilineStringState = "'''";
            }
            if (this.myInMultilineStringState != null) {
                console.setLanguage(PlainTextLanguage.INSTANCE);
                console.setPrompt("... ");
                return;
            }
        }
        if (line.endsWith("\\")) {
            console.setPrompt("... ");
            return;
        }
        if (!StringUtil.isEmptyOrSpaces((String)line)) {
            int indent = IndentHelperImpl.getIndent(this.getProject(), (FileType)PythonFileType.INSTANCE, line, false);
            boolean flag = false;
            if (PyConsoleIndentUtil.shouldIndent(line)) {
                indent += this.getPythonIndent();
                flag = true;
            }
            if (this.myCurrentIndentSize > 0 && indent > 0 || flag) {
                this.setCurrentIndentSize(indent);
                this.indentEditor(currentEditor, indent);
                PydevConsoleExecuteActionHandler.more(console, currentEditor);
                this.myConsoleCommunication.notifyCommandExecuted(true);
                return;
            }
        }
        this.sendLineToConsole(new ConsoleCommunication.ConsoleCodeFragment(this.myInputBuffer.toString(), true), console, currentEditor);
    }

    private void sendLineToConsole(final @NotNull ConsoleCommunication.ConsoleCodeFragment code, final @NotNull LanguageConsoleImpl console, final @NotNull Editor currentEditor) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "sendLineToConsole"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "sendLineToConsole"));
        }
        if (currentEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentEditor", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "sendLineToConsole"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)code.getText())) {
            ++this.myIpythonInputPromptCount;
        }
        if (this.myConsoleCommunication != null) {
            boolean waitedForInputBefore = this.myConsoleCommunication.isWaitingForInput();
            if (this.myConsoleCommunication.isWaitingForInput()) {
                this.myInputBuffer.setLength(0);
            } else {
                PydevConsoleExecuteActionHandler.executingPrompt(console);
            }
            this.myConsoleCommunication.execInterpreter(code, (Function)new Function<InterpreterResponse, Object>(){

                public Object fun(InterpreterResponse interpreterResponse) {
                    PydevConsoleExecuteActionHandler.this.myInputBuffer = null;
                    PydevConsoleExecuteActionHandler.this.getConsoleCommunication().notifyCommandExecuted(interpreterResponse.more);
                    if (interpreterResponse.more) {
                        PydevConsoleExecuteActionHandler.more(console, currentEditor);
                        if (PydevConsoleExecuteActionHandler.this.myCurrentIndentSize == 0) {
                            PydevConsoleExecuteActionHandler.this.setCurrentIndentSize(IndentHelperImpl.getIndent(PydevConsoleExecuteActionHandler.this.getProject(), (FileType)PythonFileType.INSTANCE, PydevConsoleExecuteActionHandler.lastLine(code.getText()), false) + PydevConsoleExecuteActionHandler.this.getPythonIndent());
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    PydevConsoleExecuteActionHandler.this.indentEditor(currentEditor, PydevConsoleExecuteActionHandler.this.myCurrentIndentSize);
                                }
                            });
                        }
                    } else {
                        if (!PydevConsoleExecuteActionHandler.this.myConsoleCommunication.isWaitingForInput()) {
                            PydevConsoleExecuteActionHandler.this.inPrompt(console, currentEditor);
                        }
                        PydevConsoleExecuteActionHandler.this.setCurrentIndentSize(0);
                    }
                    return null;
                }
            });
            if (waitedForInputBefore && !this.myConsoleCommunication.isWaitingForInput()) {
                --this.myIpythonInputPromptCount;
                this.inPrompt(console, currentEditor);
                this.setCurrentIndentSize(0);
            }
        }
    }

    private static String lastLine(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "lastLine"));
        }
        String[] lines = StringUtil.splitByLinesDontTrim((String)text);
        return lines[lines.length - 1];
    }

    private void inPrompt(LanguageConsoleImpl console, Editor currentEditor) {
        if (this.ipythonEnabled(console)) {
            this.ipythonInPrompt(console, currentEditor);
        } else {
            this.ordinaryPrompt(console, currentEditor);
        }
    }

    private void ordinaryPrompt(LanguageConsoleImpl console, Editor currentEditor) {
        if (!this.myConsoleCommunication.isExecuting()) {
            if (!">>> ".equals(console.getPrompt())) {
                console.setPrompt(">>> ");
                PyConsoleUtil.scrollDown(currentEditor);
            }
        } else {
            PydevConsoleExecuteActionHandler.executingPrompt(console);
        }
    }

    private boolean ipythonEnabled(LanguageConsoleImpl console) {
        return console.getFile().getVirtualFile() != null ? PyConsoleUtil.getOrCreateIPythonData(console.getFile().getVirtualFile()).isIPythonEnabled() : false;
    }

    private void ipythonInPrompt(LanguageConsoleImpl console, Editor currentEditor) {
        TextAttributes attributes = ConsoleViewContentType.USER_INPUT.getAttributes();
        attributes.setFontType(0);
        console.setPromptAttributes(attributes);
        console.setPrompt("In[" + this.myIpythonInputPromptCount + "]:");
        PyConsoleUtil.scrollDown(currentEditor);
    }

    private static void executingPrompt(LanguageConsoleImpl console) {
        console.setPrompt("");
    }

    private static void more(LanguageConsoleImpl console, Editor currentEditor) {
        if (!"... ".equals(console.getPrompt())) {
            console.setPrompt("... ");
            PyConsoleUtil.scrollDown(currentEditor);
        }
    }

    public static String getPrevCommandRunningMessage() {
        return "Previous command is still running. Please wait or press Ctrl+C in console to interrupt.";
    }

    public void commandExecuted(boolean more) {
        if (!more) {
            LanguageConsoleImpl console = this.myConsoleView.getConsole();
            EditorEx currentEditor = console.getConsoleEditor();
            if (!this.ipythonEnabled(console)) {
                this.ordinaryPrompt(console, currentEditor);
            }
        }
    }

    public void inputRequested() {
        LanguageConsoleImpl console = this.myConsoleView.getConsole();
        EditorEx currentEditor = console.getConsoleEditor();
        if (!">? ".equals(console.getPrompt()) && !"help> ".equals(console.getPrompt())) {
            console.setPrompt(">? ");
            PyConsoleUtil.scrollDown(currentEditor);
        }
        this.setCurrentIndentSize(1);
    }

    public void finishExecution() {
        LanguageConsoleImpl console = this.myConsoleView.getConsole();
        EditorEx currentEditor = console.getConsoleEditor();
        if (this.myInputBuffer != null) {
            this.processLine("\n");
        }
        this.cleanEditor(currentEditor);
    }

    public int getCurrentIndentSize() {
        return this.myCurrentIndentSize;
    }

    public void setCurrentIndentSize(int currentIndentSize) {
        this.myCurrentIndentSize = currentIndentSize;
        VirtualFile file = this.getConsoleFile();
        if (file != null) {
            PyConsoleUtil.setCurrentIndentSize(file, currentIndentSize);
        }
    }

    @Nullable
    private VirtualFile getConsoleFile() {
        if (this.myConsoleView != null) {
            return this.myConsoleView.getConsole().getFile().getVirtualFile();
        }
        return null;
    }

    public int getPythonIndent() {
        return CodeStyleSettingsManager.getSettings((Project)this.getProject()).getIndentSize((FileType)PythonFileType.INSTANCE);
    }

    private void indentEditor(final Editor editor, final int indentSize) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler$2", "run"));
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)IndentHelperImpl.fillIndent(this.getProject(), (FileType)PythonFileType.INSTANCE, indentSize));
            }
        }.execute();
    }

    private void cleanEditor(final Editor editor) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler$3", "run"));
                }
                editor.getDocument().setText((CharSequence)"");
            }
        }.execute();
    }

    private Project getProject() {
        return this.myConsoleView.getConsole().getProject();
    }

    public String getCantExecuteMessage() {
        if (!this.isEnabled()) {
            return this.getConsoleIsNotEnabledMessage();
        }
        if (!this.canExecuteNow()) {
            return PydevConsoleExecuteActionHandler.getPrevCommandRunningMessage();
        }
        return "Can't execute the command";
    }

    @Override
    public void runExecuteAction(@NotNull LanguageConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "runExecuteAction"));
        }
        if (this.isEnabled()) {
            if (!this.canExecuteNow()) {
                HintManager.getInstance().showErrorHint((Editor)console.getConsole().getConsoleEditor(), PydevConsoleExecuteActionHandler.getPrevCommandRunningMessage());
            } else {
                this.doRunExecuteAction(console);
            }
        } else {
            HintManager.getInstance().showErrorHint((Editor)console.getConsole().getConsoleEditor(), this.getConsoleIsNotEnabledMessage());
        }
    }

    private void doRunExecuteAction(LanguageConsoleView console) {
        if (PydevConsoleExecuteActionHandler.shouldCopyToHistory(console.getConsole())) {
            this.copyToHistoryAndExecute(console);
        } else {
            this.processLine(console.getConsole().getConsoleEditor().getDocument().getText());
        }
    }

    private static boolean shouldCopyToHistory(@NotNull LanguageConsoleImpl console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/jetbrains/python/console/PydevConsoleExecuteActionHandler", "shouldCopyToHistory"));
        }
        return !PyConsoleUtil.isPagingPrompt(console.getPrompt());
    }

    private void copyToHistoryAndExecute(LanguageConsoleView console) {
        super.runExecuteAction(console);
    }

    public boolean canExecuteNow() {
        return !this.myConsoleCommunication.isExecuting() || this.myConsoleCommunication.isWaitingForInput();
    }

    protected String getConsoleIsNotEnabledMessage() {
        return "Console is not enabled.";
    }

    protected void setEnabled(boolean flag) {
        this.myEnabled = flag;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public ConsoleCommunication getConsoleCommunication() {
        return this.myConsoleCommunication;
    }
}

