/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.IPydevXmlRpcClient;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.console.pydev.PydevXmlRpcClient;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PydevXmlUtils;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleCommunication
extends AbstractConsoleCommunication
implements XmlRpcHandler,
PyFrameAccessor {
    private static final String EXEC_LINE = "execLine";
    private static final String EXEC_MULTILINE = "execMultipleLines";
    private static final String GET_COMPLETIONS = "getCompletions";
    private static final String GET_DESCRIPTION = "getDescription";
    private static final String GET_FRAME = "getFrame";
    private static final String GET_VARIABLE = "getVariable";
    private static final String CHANGE_VARIABLE = "changeVariable";
    private static final String CONNECT_TO_DEBUGGER = "connectToDebugger";
    private static final String HANDSHAKE = "handshake";
    private static final String CLOSE = "close";
    private static final String EVALUATE = "evaluate";
    private static final String GET_ARRAY = "getArray";
    private IPydevXmlRpcClient myClient;
    private WebServer myWebServer;
    private static final Logger LOG = Logger.getInstance((String)PydevConsoleCommunication.class.getName());
    protected volatile String inputReceived;
    protected volatile InterpreterResponse nextResponse;
    private volatile Object lock2 = new Object();
    private volatile boolean firstCommWorked = false;
    private boolean myExecuting;
    private PythonDebugConsoleCommunication myDebugCommunication;
    private volatile Object lock = new Object();

    public PydevConsoleCommunication(Project project, int port, Process process, int clientPort) throws Exception {
        super(project);
        this.myWebServer = new WebServer(clientPort, null);
        this.myWebServer.addHandler("$default", (Object)this);
        this.myWebServer.start();
        this.myClient = new PydevXmlRpcClient(process, port);
    }

    public boolean handshake() throws XmlRpcException {
        Object ret;
        if (this.myClient != null && (ret = this.myClient.execute(HANDSHAKE, new Object[0])) instanceof String) {
            String retVal = (String)ret;
            return "PyCharm".equals(retVal);
        }
        return false;
    }

    public synchronized void close() {
        if (this.myClient != null) {
            new Task.Backgroundable(this.myProject, "Close console communication", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$1", "run"));
                    }
                    try {
                        PydevConsoleCommunication.this.myClient.execute(PydevConsoleCommunication.CLOSE, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PydevConsoleCommunication.this.myClient = null;
                }
            }.queue();
        }
        if (this.myWebServer != null) {
            this.myWebServer.shutdown();
            this.myWebServer = null;
        }
    }

    public Object execute(String method, Vector params) throws Exception {
        if ("NotifyFinished".equals(method)) {
            return this.execNotifyFinished((Boolean)params.get(0));
        }
        if ("RequestInput".equals(method)) {
            return this.execRequestInput();
        }
        if ("IPythonEditor".equals(method)) {
            return this.execIPythonEditor(params);
        }
        if ("NotifyAboutMagic".equals(method)) {
            return this.execNotifyAboutMagic(params);
        }
        throw new UnsupportedOperationException();
    }

    private Object execNotifyAboutMagic(Vector params) {
        List commands = (List)params.get(0);
        boolean isAutoMagic = (Boolean)params.get(1);
        if (this.getConsoleFile() != null) {
            PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(this.getConsoleFile());
            consoleData.setIPythonAutomagic(isAutoMagic);
            consoleData.setIPythonMagicCommands(commands);
        }
        return "";
    }

    private Object execIPythonEditor(Vector params) {
        VirtualFile file;
        String path = (String)params.get(0);
        int line = Integer.parseInt((String)params.get(1));
        VirtualFile virtualFile = file = StringUtil.isEmpty((String)path) ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AccessToken at = ApplicationManager.getApplication().acquireReadActionLock();
                    try {
                        FileEditorManager.getInstance((Project)PydevConsoleCommunication.this.myProject).openFile(file, true);
                    }
                    finally {
                        at.finish();
                    }
                }
            });
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object execNotifyFinished(boolean more) {
        this.setExecuting(false);
        this.notifyCommandExecuted(more);
        return true;
    }

    private void setExecuting(boolean executing) {
        this.myExecuting = executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execRequestInput() {
        this.waitingForInput = true;
        this.inputReceived = null;
        boolean needInput = true;
        this.nextResponse = new InterpreterResponse(false, needInput);
        this.notifyInputRequested();
        while (this.inputReceived == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.inputReceived;
    }

    protected Pair<String, Boolean> exec(ConsoleCommunication.ConsoleCodeFragment command) throws XmlRpcException {
        this.setExecuting(true);
        Object execute = this.myClient.execute(command.isSingleLine() ? EXEC_LINE : EXEC_MULTILINE, new Object[]{command.getText()});
        Object object = execute instanceof Vector ? ((Vector)execute).get(0) : (execute.getClass().isArray() ? ((Object[])execute)[0] : execute);
        Pair<String, Boolean> result = this.parseResult(object);
        if (((Boolean)result.second).booleanValue()) {
            this.setExecuting(false);
        }
        return result;
    }

    private Pair<String, Boolean> parseResult(Object object) {
        if (object instanceof Boolean) {
            return new Pair(null, (Object)((Boolean)object));
        }
        return PydevConsoleCommunication.parseExecResponseString((String)object.toString());
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text, String actTok) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            List<PydevCompletionVariant> list = this.myDebugCommunication.getCompletions(text, actTok);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleCommunication", GET_COMPLETIONS));
            }
            return list;
        }
        if (this.waitingForInput) {
            List<PydevCompletionVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleCommunication", GET_COMPLETIONS));
            }
            return list;
        }
        Object fromServer = this.myClient.execute(GET_COMPLETIONS, new Object[]{text, actTok});
        List list = PydevXmlUtils.decodeCompletions((Object)fromServer, (String)actTok);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleCommunication", GET_COMPLETIONS));
        }
        return list;
    }

    public String getDescription(String text) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            return this.myDebugCommunication.getDescription(text);
        }
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        return this.myClient.execute(GET_DESCRIPTION, new Object[]{text}).toString();
    }

    public void execInterpreter(final ConsoleCommunication.ConsoleCodeFragment command, final Function<InterpreterResponse, Object> onResponseReceived) {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            this.myDebugCommunication.execInterpreter(command, onResponseReceived);
            return;
        }
        this.nextResponse = null;
        if (this.waitingForInput) {
            this.inputReceived = command.getText();
            this.waitingForInput = false;
        } else {
            new Task.Backgroundable(this.myProject, "REPL Communication", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$3", "run"));
                    }
                    boolean needInput = false;
                    try {
                        Pair executed = null;
                        int commAttempts = 0;
                        while (true) {
                            if (indicator.isCanceled()) {
                                return;
                            }
                            executed = PydevConsoleCommunication.this.exec(command);
                            String refusedConnPattern = "Failed to read servers response";
                            if (executed.first == null || ((String)executed.first).indexOf(refusedConnPattern) == -1 || PydevConsoleCommunication.this.firstCommWorked || commAttempts >= 3) break;
                            ++commAttempts;
                            Thread.sleep(250L);
                            executed = Pair.create((Object)"", (Object)executed.second);
                        }
                        PydevConsoleCommunication.this.firstCommWorked = true;
                        boolean more = (Boolean)executed.second;
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(more, needInput);
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, needInput);
                    }
                }
            }.queue();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    progressIndicator.setText("Waiting for REPL response with 10s timeout");
                    long startTime = System.nanoTime();
                    while (PydevConsoleCommunication.this.nextResponse == null) {
                        if (progressIndicator.isCanceled()) {
                            LOG.debug("Canceled");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        long time = System.nanoTime() - startTime;
                        progressIndicator.setFraction((double)time / 1.0E10);
                        if (time > 10000000000L) {
                            LOG.debug("Timeout exceeded");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        Object object = PydevConsoleCommunication.this.lock2;
                        synchronized (object) {
                            try {
                                PydevConsoleCommunication.this.lock2.wait(20L);
                            }
                            catch (InterruptedException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                    onResponseReceived.fun((Object)PydevConsoleCommunication.this.nextResponse);
                }
            }, "Waiting for REPL response", true, this.myProject);
        }
    }

    public void interrupt() {
        try {
            this.myClient.execute("interrupt", new Object[0]);
        }
        catch (XmlRpcException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(EVALUATE, new Object[]{expression});
                if (ret instanceof String) {
                    return ProtocolParser.parseValue((String)((String)ret), (PyFrameAccessor)this);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_FRAME, new Object[0]);
                if (ret instanceof String) {
                    return this.parseVars((String)ret, null);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get frame from console failed", (Throwable)e);
            }
        }
        return new XValueChildrenList();
    }

    private XValueChildrenList parseVars(String ret, PyDebugValue parent) throws PyDebuggerException {
        List values = ProtocolParser.parseValues((String)ret, (PyFrameAccessor)this);
        XValueChildrenList list = new XValueChildrenList(values.size());
        for (PyDebugValue v : values) {
            list.add(v.getName(), (XValue)(parent != null ? v.setParent(parent) : v));
        }
        return list;
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_VARIABLE, new Object[]{GetVariableCommand.composeName((PyDebugValue)var)});
                if (ret instanceof String) {
                    return this.parseVars((String)ret, var);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get variable from console failed", (Throwable)e);
            }
        }
        return new XValueChildrenList();
    }

    public void changeVariable(PyDebugValue variable, String value) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(CHANGE_VARIABLE, new Object[]{variable.getEvaluationExpression(), value});
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get change variable", (Throwable)e);
            }
        }
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        return null;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_ARRAY, new Object[]{var.getName(), rowOffset, colOffset, rows, cols, format});
                if (ret instanceof String) {
                    return ProtocolParser.parseArrayValues((String)((String)ret), (PyFrameAccessor)this);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    public void connectToDebugger(int localPort) throws Exception {
        Vector resultarray;
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        Object result = this.myClient.execute(CONNECT_TO_DEBUGGER, new Object[]{localPort});
        Exception exception = null;
        if (result instanceof Vector && (resultarray = (Vector)result).size() == 1) {
            if ("connect complete".equals(resultarray.get(0))) {
                return;
            }
            if (resultarray.get(0) instanceof String) {
                exception = new Exception((String)resultarray.get(0));
            }
            if (resultarray.get(0) instanceof Exception) {
                exception = (Exception)resultarray.get(0);
            }
        }
        throw new PyDebuggerException("pydevconsole failed to execute connectToDebugger", exception);
    }

    private static void checkError(Object ret) throws PyDebuggerException {
        if (ret instanceof Object[] && ((Object[])ret).length == 1) {
            throw new PyDebuggerException(((Object[])ret)[0].toString());
        }
    }

    public void setDebugCommunication(PythonDebugConsoleCommunication debugCommunication) {
        this.myDebugCommunication = debugCommunication;
    }

    public PythonDebugConsoleCommunication getDebugCommunication() {
        return this.myDebugCommunication;
    }
}

