/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import icons.PythonIcons;
import java.awt.Component;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyOpenDebugConsoleAction
extends AnAction
implements DumbAware {
    public PyOpenDebugConsoleAction() {
        this.getTemplatePresentation().setIcon(PythonIcons.Python.Debug.CommandLine);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(true);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            e.getPresentation().setVisible(PyOpenDebugConsoleAction.getConsoles(project).size() > 0);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            PyOpenDebugConsoleAction.selectRunningProcess(e.getDataContext(), project, new Consumer<PythonDebugLanguageConsoleView>(){

                public void consume(PythonDebugLanguageConsoleView view) {
                    view.enableConsole(false);
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)view.getPydevConsoleView().getComponent(), true);
                }
            });
        }
    }

    private static void selectRunningProcess(@NotNull DataContext dataContext, @NotNull Project project, final Consumer<PythonDebugLanguageConsoleView> consumer) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/console/PyOpenDebugConsoleAction", "selectRunningProcess"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PyOpenDebugConsoleAction", "selectRunningProcess"));
        }
        Collection<RunContentDescriptor> consoles = PyOpenDebugConsoleAction.getConsoles(project);
        ExecutionHelper.selectContentDescriptor(dataContext, project, consoles, "Select running python process", new Consumer<RunContentDescriptor>(){

            public void consume(RunContentDescriptor descriptor) {
                if (descriptor != null && descriptor.getExecutionConsole() instanceof PythonDebugLanguageConsoleView) {
                    consumer.consume((Object)((PythonDebugLanguageConsoleView)descriptor.getExecutionConsole()));
                }
            }
        });
    }

    private static Collection<RunContentDescriptor> getConsoles(Project project) {
        return ExecutionHelper.findRunningConsole(project, new NotNullFunction<RunContentDescriptor, Boolean>(){

            @NotNull
            public Boolean fun(RunContentDescriptor dom) {
                Boolean bl = dom.getExecutionConsole() instanceof PythonDebugLanguageConsoleView && PyOpenDebugConsoleAction.isAlive(dom);
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyOpenDebugConsoleAction$3", "fun"));
                }
                return bl;
            }
        });
    }

    private static boolean isAlive(RunContentDescriptor dom) {
        ProcessHandler processHandler = dom.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }
}

