/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConsoleUtil {
    public static final String ORDINARY_PROMPT = ">>> ";
    public static final String INPUT_PROMPT = ">? ";
    public static final String INDENT_PROMPT = "... ";
    static final String HELP_PROMPT = "help> ";
    public static final String EXECUTING_PROMPT = "";
    private static final String IPYTHON_PAGING_PROMPT = "---Return to continue, q to quit---";
    static final String[] PROMPTS = new String[]{">>> ", "... ", "help> ", "---Return to continue, q to quit---"};
    public static final String DOUBLE_QUOTE_MULTILINE = "\"\"\"";
    public static final String SINGLE_QUOTE_MULTILINE = "'''";
    static final Key<PythonConsoleData> PYTHON_CONSOLE_DATA = Key.create((String)"python-console-data");

    private PyConsoleUtil() {
    }

    public static boolean isPagingPrompt(@Nullable String prompt) {
        return prompt != null && IPYTHON_PAGING_PROMPT.equals(prompt.trim());
    }

    static String processPrompts(LanguageConsoleImpl languageConsole, String string) {
        for (String prompt : PROMPTS) {
            if (!string.startsWith(prompt)) continue;
            if (prompt != HELP_PROMPT) {
                StringBuilder builder = new StringBuilder();
                builder.append(prompt).append(prompt);
                while (string.startsWith(builder.toString())) {
                    builder.append(prompt);
                }
                String multiPrompt = builder.toString().substring(prompt.length());
                if (prompt == INDENT_PROMPT) {
                    prompt = multiPrompt;
                }
                string = string.substring(multiPrompt.length());
            } else {
                string = string.substring(prompt.length());
            }
            String currentPrompt = languageConsole.getPrompt();
            String trimmedPrompt = prompt.trim();
            if (currentPrompt == null || currentPrompt.equals(trimmedPrompt)) break;
            languageConsole.setPrompt(trimmedPrompt);
            PyConsoleUtil.scrollDown(languageConsole.getConsoleEditor());
            break;
        }
        return string;
    }

    public static boolean isMultilineStarts(String line, String substring) {
        return StringUtil.getOccurrenceCount((String)line, (String)substring) % 2 == 1;
    }

    public static void scrollDown(final Editor currentEditor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                currentEditor.getCaretModel().moveToOffset(currentEditor.getDocument().getTextLength());
            }
        });
    }

    public static boolean isSingleQuoteMultilineStarts(String line) {
        return PyConsoleUtil.isMultilineStarts(line, SINGLE_QUOTE_MULTILINE);
    }

    public static boolean isDoubleQuoteMultilineStarts(String line) {
        return PyConsoleUtil.isMultilineStarts(line, DOUBLE_QUOTE_MULTILINE);
    }

    public static boolean detectIPythonImported(@NotNull String text, ConsoleViewContentType outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectIPythonImported"));
        }
        return text.contains("PyDev console: using IPython ") && outputType == ConsoleViewContentType.ERROR_OUTPUT;
    }

    public static boolean detectSourcePrinting(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectSourcePrinting"));
        }
        return text.contains("Source:");
    }

    public static boolean detectIPythonStart(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectIPythonStart"));
        }
        return text.contains("IPython-->");
    }

    public static boolean detectIPythonEnd(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectIPythonEnd"));
        }
        return text.contains("<--IPython");
    }

    public static boolean detectIPythonAutomagicOn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectIPythonAutomagicOn"));
        }
        return text.contains("Automagic is ON, % prefix NOT needed for magic functions.");
    }

    public static boolean detectIPythonAutomagicOff(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/console/PyConsoleUtil", "detectIPythonAutomagicOff"));
        }
        return text.contains("Automagic is OFF, % prefix IS needed for magic functions.");
    }

    public static void markIPython(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/console/PyConsoleUtil", "markIPython"));
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonEnabled(true);
    }

    @NotNull
    public static PythonConsoleData getOrCreateIPythonData(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/console/PyConsoleUtil", "getOrCreateIPythonData"));
        }
        PythonConsoleData consoleData = (PythonConsoleData)file.getUserData(PYTHON_CONSOLE_DATA);
        if (consoleData == null) {
            consoleData = new PythonConsoleData();
            file.putUserData(PYTHON_CONSOLE_DATA, (Object)consoleData);
        }
        PythonConsoleData pythonConsoleData = consoleData;
        if (pythonConsoleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyConsoleUtil", "getOrCreateIPythonData"));
        }
        return pythonConsoleData;
    }

    public static void setIPythonAutomagic(@NotNull VirtualFile file, boolean detected) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/console/PyConsoleUtil", "setIPythonAutomagic"));
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonAutomagic(detected);
    }

    public static void setCurrentIndentSize(@NotNull VirtualFile file, int indentSize) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/console/PyConsoleUtil", "setCurrentIndentSize"));
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIndentSize(indentSize);
    }
}

