/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.highlighting.PyHighlighter;

class PyConsoleSourceHighlighter {
    private final Lexer myLexer;
    private final EditorColorsScheme myScheme;
    private final PyHighlighter myPyHighlighter;
    private int myLexerState;
    private PythonConsoleView myPythonConsoleView;

    PyConsoleSourceHighlighter(PythonConsoleView pythonConsoleView, EditorColorsScheme scheme, PyHighlighter pyHighlighter) {
        this.myPythonConsoleView = pythonConsoleView;
        this.myScheme = scheme;
        this.myPyHighlighter = pyHighlighter;
        this.myLexer = this.myPyHighlighter.getHighlightingLexer();
    }

    public void printHighlightedSource(String text) {
        this.myLexer.start((CharSequence)text, 0, text.length(), this.getLexerState());
        while (this.hasNext()) {
            Pair<String, ConsoleViewContentType> pair = this.next();
            this.myPythonConsoleView.printText((String)pair.first, (ConsoleViewContentType)pair.second);
        }
    }

    private boolean hasNext() {
        return this.myLexer.getTokenType() != null;
    }

    private Pair<String, ConsoleViewContentType> next() {
        this.myLexerState = this.myLexer.getState();
        Pair res = Pair.create((Object)this.myLexer.getTokenText(), (Object)new ConsoleViewContentType("", this.convertAttributes(this.myPyHighlighter.getTokenHighlights(this.myLexer.getTokenType()))));
        this.myLexer.advance();
        return res;
    }

    private int getLexerState() {
        return this.myLexerState != 1024 ? this.myLexerState : 0;
    }

    protected TextAttributes convertAttributes(TextAttributesKey[] keys) {
        EditorColorsScheme scheme = this.myScheme;
        TextAttributes attrs = scheme.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = scheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge((TextAttributes)attrs, (TextAttributes)attrs2);
        }
        return attrs;
    }
}

