/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.run.PythonProcessHandler;
import java.nio.charset.Charset;

public class PyConsoleProcessHandler
extends PythonProcessHandler {
    private final PythonConsoleView myConsoleView;
    private final PydevConsoleCommunication myPydevConsoleCommunication;

    public PyConsoleProcessHandler(Process process, PythonConsoleView consoleView, PydevConsoleCommunication pydevConsoleCommunication, String commandLine, Charset charset) {
        super(process, commandLine, charset);
        this.myConsoleView = consoleView;
        this.myPydevConsoleCommunication = pydevConsoleCommunication;
    }

    public void coloredTextAvailable(String text, Key attributes) {
        String string = PyConsoleUtil.processPrompts(this.getConsole(), StringUtil.convertLineSeparators((String)text));
        this.myConsoleView.print(string, attributes);
        this.notifyColoredListeners(text, attributes);
    }

    protected void closeStreams() {
        this.doCloseCommunication();
        super.closeStreams();
    }

    public boolean isSilentlyDestroyOnClose() {
        return !this.myPydevConsoleCommunication.isExecuting();
    }

    @Override
    protected boolean shouldKillProcessSoftly() {
        return false;
    }

    private void doCloseCommunication() {
        if (this.myPydevConsoleCommunication != null) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        PyConsoleProcessHandler.this.myPydevConsoleCommunication.close();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private LanguageConsoleImpl getConsole() {
        return this.myConsoleView.getConsole();
    }
}

