/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Lists;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleOptionsProvider;
import com.jetbrains.python.console.PyConsoleSpecificOptionsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyConsoleOptionsConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    public static final String CONSOLE_SETTINGS_HELP_REFERENCE = "reference.project.settings.console";
    public static final String CONSOLE_SETTINGS_HELP_REFERENCE_PYTHON = "reference.project.settings.console.python";
    private PyConsoleOptionsPanel myPanel;
    private final PyConsoleOptions myOptionsProvider;
    private Project myProject;

    public PyConsoleOptionsConfigurable(PyConsoleOptions optionsProvider, Project project) {
        this.myOptionsProvider = optionsProvider;
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        if ("pyconsole" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyConsoleOptionsConfigurable", "getId"));
        }
        return "pyconsole";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    protected Configurable[] buildConfigurables() {
        ArrayList result = Lists.newArrayList();
        PyConsoleSpecificOptionsPanel pythonConsoleOptionsPanel = new PyConsoleSpecificOptionsPanel(this.myProject);
        result.add(PyConsoleOptionsConfigurable.createConsoleChildConfigurable("Python Console", pythonConsoleOptionsPanel, this.myOptionsProvider.getPythonConsoleSettings(), CONSOLE_SETTINGS_HELP_REFERENCE_PYTHON));
        for (PyConsoleOptionsProvider provider : (PyConsoleOptionsProvider[])Extensions.getExtensions(PyConsoleOptionsProvider.EP_NAME)) {
            if (!provider.isApplicableTo(this.myProject)) continue;
            result.add(PyConsoleOptionsConfigurable.createConsoleChildConfigurable(provider.getName(), new PyConsoleSpecificOptionsPanel(this.myProject), provider.getSettings(this.myProject), provider.getHelpTopic()));
        }
        return result.toArray(new Configurable[result.size()]);
    }

    private static Configurable createConsoleChildConfigurable(final String name, final PyConsoleSpecificOptionsPanel panel, final PyConsoleOptions.PyConsoleSettings settings, final String helpReference) {
        return new SearchableConfigurable(){

            @NotNull
            public String getId() {
                String string = "PyConsoleConfigurable." + name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyConsoleOptionsConfigurable$1", "getId"));
                }
                return string;
            }

            public Runnable enableSearch(String option) {
                return null;
            }

            @Nls
            public String getDisplayName() {
                return name;
            }

            public String getHelpTopic() {
                return helpReference;
            }

            public JComponent createComponent() {
                return panel.createPanel(settings);
            }

            public boolean isModified() {
                return panel.isModified();
            }

            public void apply() throws ConfigurationException {
                panel.apply();
            }

            public void reset() {
                panel.reset();
            }

            public void disposeUIResources() {
            }
        };
    }

    @Nls
    public String getDisplayName() {
        return "Console";
    }

    public String getHelpTopic() {
        return CONSOLE_SETTINGS_HELP_REFERENCE;
    }

    public JComponent createComponent() {
        this.myPanel = new PyConsoleOptionsPanel();
        return this.myPanel.createPanel(this.myOptionsProvider);
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static class PyConsoleOptionsPanel {
        private JPanel myWholePanel;
        private JBCheckBox myShowDebugConsoleByDefault;
        private JBCheckBox myShowSeparatorLine;
        private JBCheckBox myIpythonEnabledCheckbox;
        private PyConsoleOptions myOptionsProvider;

        private PyConsoleOptionsPanel() {
            this.$$$setupUI$$$();
        }

        public JPanel createPanel(PyConsoleOptions optionsProvider) {
            this.myOptionsProvider = optionsProvider;
            return this.myWholePanel;
        }

        public void apply() {
            this.myOptionsProvider.setShowDebugConsoleByDefault(this.myShowDebugConsoleByDefault.isSelected());
            this.myOptionsProvider.setShowSeparatorLine(this.myShowSeparatorLine.isSelected());
            this.myOptionsProvider.setIpythonEnabled(this.myIpythonEnabledCheckbox.isSelected());
        }

        public void reset() {
            this.myShowDebugConsoleByDefault.setSelected(this.myOptionsProvider.isShowDebugConsoleByDefault());
            this.myShowSeparatorLine.setSelected(this.myOptionsProvider.isShowSeparatorLine());
            this.myIpythonEnabledCheckbox.setSelected(this.myOptionsProvider.isIpythonEnabled());
        }

        public boolean isModified() {
            return this.myShowDebugConsoleByDefault.isSelected() != this.myOptionsProvider.isShowDebugConsoleByDefault() || this.myShowSeparatorLine.isSelected() != this.myOptionsProvider.isShowSeparatorLine() || this.myIpythonEnabledCheckbox.isSelected() != this.myOptionsProvider.isIpythonEnabled();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JBCheckBox jBCheckBox3;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"General settings", (int)0, (int)0, null, null));
            this.myShowDebugConsoleByDefault = jBCheckBox3 = new JBCheckBox();
            jBCheckBox3.setText("Always show debug console");
            jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIpythonEnabledCheckbox = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setText("Use IPython if available");
            jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myShowSeparatorLine = jBCheckBox = new JBCheckBox();
            jBCheckBox.setText("Show separator line");
            jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

