/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PyConsoleOptionsProvider", storages={@Storage(file="$WORKSPACE_FILE$")})
public class PyConsoleOptions
implements PersistentStateComponent<State> {
    private State myState = new State();

    public PyConsoleSettings getPythonConsoleSettings() {
        return this.myState.myPythonConsoleState;
    }

    public boolean isShowDebugConsoleByDefault() {
        return this.myState.myShowDebugConsoleByDefault;
    }

    public void setShowDebugConsoleByDefault(boolean showDebugConsoleByDefault) {
        this.myState.myShowDebugConsoleByDefault = showDebugConsoleByDefault;
    }

    public boolean isShowSeparatorLine() {
        return this.myState.myShowSeparatorLine;
    }

    public void setShowSeparatorLine(boolean showSeparatorLine) {
        this.myState.myShowSeparatorLine = showSeparatorLine;
    }

    public boolean isIpythonEnabled() {
        return this.myState.myIpythonEnabled;
    }

    public void setIpythonEnabled(boolean enabled) {
        this.myState.myIpythonEnabled = enabled;
    }

    public static PyConsoleOptions getInstance(Project project) {
        return (PyConsoleOptions)ServiceManager.getService((Project)project, PyConsoleOptions.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state2) {
        this.myState.myShowDebugConsoleByDefault = state2.myShowDebugConsoleByDefault;
        this.myState.myShowSeparatorLine = state2.myShowSeparatorLine;
        this.myState.myPythonConsoleState = state2.myPythonConsoleState;
        this.myState.myIpythonEnabled = state2.myIpythonEnabled;
    }

    @Tag(value="console-settings")
    public static class PyConsoleSettings {
        public String myCustomStartScript = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
        public String mySdkHome = null;
        public String myInterpreterOptions = "";
        public boolean myUseModuleSdk;
        public String myModuleName = null;
        public Map<String, String> myEnvs = Maps.newHashMap();
        public String myWorkingDirectory = "";
        public boolean myAddContentRoots = true;
        public boolean myAddSourceRoots;
        @NotNull
        private PathMappingSettings myMappings = new PathMappingSettings();

        public PyConsoleSettings() {
        }

        public PyConsoleSettings(String myCustomStartScript) {
            this.myCustomStartScript = myCustomStartScript;
        }

        public void apply(AbstractPyCommonOptionsForm form) {
            this.mySdkHome = form.getSdkHome();
            this.myInterpreterOptions = form.getInterpreterOptions();
            this.myEnvs = form.getEnvs();
            this.myUseModuleSdk = form.isUseModuleSdk();
            this.myModuleName = form.getModule() == null ? null : form.getModule().getName();
            this.myWorkingDirectory = form.getWorkingDirectory();
            this.myAddContentRoots = form.shouldAddContentRoots();
            this.myAddSourceRoots = form.shouldAddSourceRoots();
            this.myMappings = form.getMappingSettings() == null ? new PathMappingSettings() : form.getMappingSettings();
        }

        public boolean isModified(AbstractPyCommonOptionsForm form) {
            return !ComparatorUtil.equalsNullable((Object)this.mySdkHome, (Object)form.getSdkHome()) || !this.myInterpreterOptions.equals(form.getInterpreterOptions()) || !((Object)this.myEnvs).equals(form.getEnvs()) || this.myUseModuleSdk != form.isUseModuleSdk() || this.myAddContentRoots != form.shouldAddContentRoots() || this.myAddSourceRoots != form.shouldAddSourceRoots() || !ComparatorUtil.equalsNullable((Object)this.myModuleName, form.getModule() == null ? null : form.getModule().getName()) || !this.myWorkingDirectory.equals(form.getWorkingDirectory()) || !this.myMappings.equals((Object)form.getMappingSettings());
        }

        public void reset(Project project, AbstractPyCommonOptionsForm form) {
            form.setEnvs(this.myEnvs);
            form.setInterpreterOptions(this.myInterpreterOptions);
            form.setSdkHome(this.mySdkHome);
            form.setUseModuleSdk(this.myUseModuleSdk);
            form.setAddContentRoots(this.myAddContentRoots);
            form.setAddSourceRoots(this.myAddSourceRoots);
            boolean moduleWasAutoselected = false;
            if (form.isUseModuleSdk() != this.myUseModuleSdk) {
                this.myUseModuleSdk = form.isUseModuleSdk();
                moduleWasAutoselected = true;
            }
            if (this.myModuleName != null) {
                form.setModule(ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName));
            }
            if (moduleWasAutoselected && form.getModule() != null) {
                this.myModuleName = form.getModule().getName();
            }
            form.setWorkingDirectory(this.myWorkingDirectory);
            form.setMappingSettings(this.myMappings);
        }

        @Attribute(value="custom-start-script")
        public String getCustomStartScript() {
            return this.myCustomStartScript;
        }

        @Attribute(value="sdk-home")
        public String getSdkHome() {
            return this.mySdkHome;
        }

        @Attribute(value="module-name")
        public String getModuleName() {
            return this.myModuleName;
        }

        @Attribute(value="working-directory")
        public String getWorkingDirectory() {
            return this.myWorkingDirectory;
        }

        @Attribute(value="is-module-sdk")
        public boolean isUseModuleSdk() {
            return this.myUseModuleSdk;
        }

        @Tag(value="envs")
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, keyAttributeName="key", entryTagName="env", valueAttributeName="value", surroundValueWithTag=false)
        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        @Attribute(value="add-content-roots")
        public boolean addContentRoots() {
            return this.myAddContentRoots;
        }

        @Attribute(value="add-source-roots")
        public boolean addSourceRoots() {
            return this.myAddSourceRoots;
        }

        @Attribute(value="interpreter-options")
        public String getInterpreterOptions() {
            return this.myInterpreterOptions;
        }

        @AbstractCollection(surroundWithTag=false)
        public PathMappingSettings getMappings() {
            return this.myMappings;
        }

        public void setCustomStartScript(String customStartScript) {
            this.myCustomStartScript = customStartScript;
        }

        public void setSdkHome(String sdkHome) {
            this.mySdkHome = sdkHome;
        }

        public void setInterpreterOptions(String interpreterOptions) {
            this.myInterpreterOptions = interpreterOptions;
        }

        public void setUseModuleSdk(boolean useModuleSdk) {
            this.myUseModuleSdk = useModuleSdk;
        }

        public void setModuleName(String moduleName) {
            this.myModuleName = moduleName;
        }

        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }

        public void setWorkingDirectory(String workingDirectory) {
            this.myWorkingDirectory = workingDirectory;
        }

        public void setAddContentRoots(boolean addContentRoots) {
            this.myAddContentRoots = addContentRoots;
        }

        public void setAddSourceRoots(boolean addSourceRoots) {
            this.myAddSourceRoots = addSourceRoots;
        }

        public void setMappings(@Nullable PathMappingSettings mappings) {
            this.myMappings = mappings != null ? mappings : new PathMappingSettings();
        }
    }

    public static class State {
        public PyConsoleSettings myPythonConsoleState = new PyConsoleSettings();
        public boolean myShowDebugConsoleByDefault = false;
        public boolean myShowSeparatorLine = true;
        public boolean myIpythonEnabled = true;
    }
}

