/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyPositionConverter;
import java.io.OutputStream;
import org.jetbrains.annotations.Nullable;

public class PyConsoleDebugProcessHandler
extends ProcessHandler
implements PositionConverterProvider {
    private final PyConsoleProcessHandler myConsoleProcessHandler;

    public PyConsoleDebugProcessHandler(PyConsoleProcessHandler processHandler) {
        this.myConsoleProcessHandler = processHandler;
        processHandler.addProcessListener(new ProcessListener(){

            public void startNotified(ProcessEvent event) {
            }

            public void processTerminated(ProcessEvent event) {
                PyConsoleDebugProcessHandler.this.notifyProcessTerminated(event.getExitCode());
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
            }
        });
        processHandler.addColoredTextListener(new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(String text, Key attributes) {
                PyConsoleDebugProcessHandler.this.notifyTextAvailable(text, attributes);
            }
        });
    }

    protected void destroyProcessImpl() {
        this.detachProcessImpl();
    }

    protected void detachProcessImpl() {
        this.notifyProcessTerminated(0);
        this.notifyTextAvailable("Debugger disconnected.\n", ProcessOutputTypes.SYSTEM);
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    public PyConsoleProcessHandler getConsoleProcessHandler() {
        return this.myConsoleProcessHandler;
    }

    @Override
    @Nullable
    public PyPositionConverter createPositionConverter(PyDebugProcess debugProcess) {
        if (this.myConsoleProcessHandler instanceof PositionConverterProvider) {
            return ((PositionConverterProvider)((Object)this.myConsoleProcessHandler)).createPositionConverter(debugProcess);
        }
        return new PyLocalPositionConverter();
    }
}

