/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.remote.RemoteProcessHandlerBase;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;

public class PyConsoleDebugProcess
extends PyDebugProcess {
    private final int myLocalPort;
    private final PyConsoleDebugProcessHandler myConsoleDebugProcessHandler;

    public PyConsoleDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull PyConsoleDebugProcessHandler consoleDebugProcessHandler) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/console/PyConsoleDebugProcess", "<init>"));
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/console/PyConsoleDebugProcess", "<init>"));
        }
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/jetbrains/python/console/PyConsoleDebugProcess", "<init>"));
        }
        if (consoleDebugProcessHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleDebugProcessHandler", "com/jetbrains/python/console/PyConsoleDebugProcess", "<init>"));
        }
        super(session, serverSocket, executionConsole, consoleDebugProcessHandler, false);
        this.myLocalPort = serverSocket.getLocalPort();
        this.myConsoleDebugProcessHandler = consoleDebugProcessHandler;
    }

    @Override
    public void sessionInitialized() {
    }

    @Override
    protected String getConnectionMessage() {
        return "Connecting to console...";
    }

    @Override
    protected String getConnectionTitle() {
        return "Debugger connection";
    }

    @Override
    protected void detachDebuggedProcess() {
    }

    @Override
    protected void beforeConnect() {
        this.printToConsole(this.getCurrentStateMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    protected void afterConnect() {
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    public void connect(PydevConsoleCommunication consoleCommunication) throws Exception {
        int portToConnect = this.myConsoleDebugProcessHandler.getConsoleProcessHandler() instanceof RemoteProcessHandlerBase ? PyConsoleDebugProcess.getRemoteTunneledPort(this.myLocalPort, (RemoteProcessHandlerBase)((Object)this.myConsoleDebugProcessHandler.getConsoleProcessHandler())) : this.myLocalPort;
        consoleCommunication.connectToDebugger(portToConnect);
    }

    public void waitForNextConnection() {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (this.getSession().isSuspended()) {
            this.getSession().resume();
        }
        if (!this.isWaitingForConnection()) {
            this.setWaitingForConnection(true);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    PyConsoleDebugProcess.this.waitForConnection(PyConsoleDebugProcess.this.getCurrentStateMessage(), PyConsoleDebugProcess.this.getConnectionTitle());
                }
            });
        }
    }
}

