/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class VirtualEnvProjectFilter
implements Predicate<Sdk> {
    private final String myBasePath;

    public VirtualEnvProjectFilter(@Nullable String basePath) {
        this.myBasePath = basePath;
    }

    public boolean apply(@Nullable Sdk input) {
        String path;
        PythonSdkAdditionalData data;
        return input != null && PythonSdkType.isVirtualEnv(input) && (data = (PythonSdkAdditionalData)input.getSdkAdditionalData()) != null && (path = data.getAssociatedProjectPath()) != null && (this.myBasePath == null || !path.equals(this.myBasePath));
    }

    public static boolean removeNotMatching(Project project, List<Sdk> sdks) {
        String basePath;
        if (project != null && (basePath = project.getBasePath()) != null) {
            return Iterables.removeIf(sdks, (Predicate)new VirtualEnvProjectFilter(FileUtil.toSystemIndependentName((String)basePath)));
        }
        return false;
    }

    public static void removeAllAssociated(List<Sdk> sdks) {
        Iterables.removeIf(sdks, (Predicate)new VirtualEnvProjectFilter(null));
    }
}

