/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NullableConsumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.configuration.AddVEnvOptionsDialog;
import com.jetbrains.python.configuration.EditSdkDialog;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonPathDialog;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.configuration.VirtualEnvProjectFilter;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JList mySdkList;
    private boolean mySdkListChanged = false;
    private final PyConfigurableInterpreterList myInterpreterList;
    private final ProjectSdksModel myProjectSdksModel;
    private Map<Sdk, SdkModificator> myModificators = new FactoryMap<Sdk, SdkModificator>(){

        protected SdkModificator create(Sdk sdk) {
            return sdk.getSdkModificator();
        }
    };
    private Set<SdkModificator> myModifiedModificators = new HashSet<SdkModificator>();
    private final Project myProject;
    private boolean myShowOtherProjectVirtualenvs = true;
    private final Module myModule;
    private NullableConsumer<Sdk> myShowMoreCallback;
    private SdkModel.Listener myListener;

    public PythonSdkDetailsDialog(Project project, NullableConsumer<Sdk> showMoreCallback) {
        super(project, true);
        this.myModule = null;
        this.setTitle("Project Interpreters");
        this.myShowMoreCallback = showMoreCallback;
        this.myProject = project;
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.init();
        this.updateOkButton();
    }

    protected void dispose() {
        this.myProjectSdksModel.removeListener(this.myListener);
        super.dispose();
    }

    public PythonSdkDetailsDialog(Module module, NullableConsumer<Sdk> showMoreCallback) {
        super(module.getProject());
        this.myModule = module;
        this.setTitle("Project Interpreters");
        this.myShowMoreCallback = showMoreCallback;
        this.myProject = module.getProject();
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.init();
        this.updateOkButton();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.mySdkList = new JBList();
        this.mySdkList.setCellRenderer(new PySdkListCellRenderer("", this.myModificators));
        this.mySdkList.setSelectionMode(0);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.mySdkList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.addSdk(button);
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.editSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.removeSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }).addExtraAction((AnActionButton)new ToggleVirtualEnvFilterButton()).addExtraAction((AnActionButton)new ShowPathButton());
        decorator.setPreferredSize(new Dimension(600, 500));
        this.myMainPanel = decorator.createPanel();
        this.refreshSdkList();
        this.addListeners();
        return this.myMainPanel;
    }

    private void addListeners() {
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
            }

            public void beforeSdkRemove(Sdk sdk) {
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                PythonSdkDetailsDialog.this.refreshSdkList();
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            }
        };
        this.myProjectSdksModel.addListener(this.myListener);
        this.mySdkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySdkList;
    }

    public boolean isModified() {
        Sdk projectSdk = this.getSdk();
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
        }
        return this.getSelectedSdk() != projectSdk || this.mySdkListChanged || this.myProjectSdksModel.isModified() || !this.myModifiedModificators.isEmpty();
    }

    protected void updateOkButton() {
        super.setOKActionEnabled(this.isModified());
    }

    protected void doOKAction() {
        try {
            this.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        super.doOKAction();
    }

    public void apply() throws ConfigurationException {
        for (SdkModificator modificator : this.myModifiedModificators) {
            modificator.commitChanges();
        }
        this.myModificators.clear();
        this.myModifiedModificators.clear();
        this.mySdkListChanged = false;
        this.myShowMoreCallback.consume((Object)this.getSelectedSdk());
        Disposer.dispose((Disposable)this.getDisposable());
    }

    @Nullable
    public Sdk getSelectedSdk() {
        return (Sdk)this.mySdkList.getSelectedValue();
    }

    private void refreshSdkList() {
        List<Sdk> pythonSdks = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk projectSdk = this.getSdk();
        if (!this.myShowOtherProjectVirtualenvs) {
            VirtualEnvProjectFilter.removeNotMatching(this.myProject, pythonSdks);
        }
        this.mySdkList.setModel(new CollectionListModel(pythonSdks));
        this.mySdkListChanged = false;
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
            this.mySdkList.clearSelection();
            this.mySdkList.setSelectedValue(projectSdk, true);
            this.mySdkList.updateUI();
        }
    }

    @Nullable
    private Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    private void addSdk(AnActionButton button) {
        PythonSdkDetailsStep.show(this.myProject, this.myProjectSdksModel.getSdks(), null, this.myMainPanel, button.getPreferredPopupPoint().getScreenPoint(), new NullableConsumer<Sdk>(){

            public void consume(Sdk sdk) {
                PythonSdkDetailsDialog.this.addCreatedSdk(sdk, true);
            }
        });
    }

    private void addCreatedSdk(@Nullable Sdk sdk, boolean newVirtualEnv) {
        if (sdk != null) {
            Sdk oldSdk;
            PySdkService sdkService = PySdkService.getInstance();
            sdkService.restoreSdk(sdk);
            boolean isVirtualEnv = PythonSdkType.isVirtualEnv(sdk);
            if (isVirtualEnv && !newVirtualEnv) {
                AddVEnvOptionsDialog dialog = new AddVEnvOptionsDialog(this.myMainPanel);
                dialog.show();
                if (dialog.getExitCode() != 0) {
                    return;
                }
                SdkModificator modificator = this.myModificators.get(sdk);
                this.setSdkAssociated(modificator, !dialog.makeAvailableToAll());
                this.myModifiedModificators.add(modificator);
            }
            if ((oldSdk = this.myProjectSdksModel.findSdk(sdk)) == null) {
                this.myProjectSdksModel.addSdk(sdk);
            }
            this.refreshSdkList();
            this.mySdkList.setSelectedValue(sdk, true);
            this.mySdkListChanged = true;
        }
    }

    private void editSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            if (currentSdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
                this.editRemoteSdk(currentSdk);
            } else {
                this.editSdk(currentSdk);
            }
        }
    }

    private void editRemoteSdk(Sdk currentSdk) {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            SdkModificator modificator = this.myModificators.get(currentSdk);
            HashSet existingSdks = Sets.newHashSet((Object[])this.myProjectSdksModel.getSdks());
            existingSdks.remove(currentSdk);
            if (remoteInterpreterManager.editSdk(this.myProject, modificator, existingSdks)) {
                this.myModifiedModificators.add(modificator);
            }
        }
    }

    private void editSdk(final Sdk currentSdk) {
        SdkModificator modificator = this.myModificators.get(currentSdk);
        EditSdkDialog dialog = new EditSdkDialog(this.myProject, modificator, new NullableFunction<String, String>(){

            public String fun(String s) {
                if (PythonSdkDetailsDialog.this.isDuplicateSdkName(s, currentSdk)) {
                    return "Please specify a unique name for the interpreter";
                }
                return null;
            }
        });
        dialog.show();
        if (dialog.isOK()) {
            boolean pathChanged;
            boolean bl = pathChanged = !Comparing.equal((String)currentSdk.getHomePath(), (String)dialog.getHomePath());
            if (!modificator.getName().equals(dialog.getName()) || pathChanged || dialog.isAssociateChanged()) {
                this.myModifiedModificators.add(modificator);
                modificator.setName(dialog.getName());
                modificator.setHomePath(dialog.getHomePath());
                if (dialog.isAssociateChanged()) {
                    this.setSdkAssociated(modificator, dialog.associateWithProject());
                }
                if (pathChanged) {
                    this.reloadSdk(currentSdk);
                }
            }
        }
    }

    private void setSdkAssociated(SdkModificator modificator, boolean isAssociated) {
        PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
        if (additionalData == null) {
            additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(modificator.getHomePath()));
            modificator.setSdkAdditionalData((SdkAdditionalData)additionalData);
        }
        if (isAssociated) {
            additionalData.associateWithProject(this.myProject);
        } else {
            additionalData.setAssociatedProjectPath(null);
        }
    }

    private boolean isDuplicateSdkName(String s, Sdk sdk) {
        for (Sdk existingSdk : this.myProjectSdksModel.getSdks()) {
            String existingName;
            if (existingSdk == sdk || !(existingName = this.myModificators.containsKey(existingSdk) ? this.myModificators.get(existingSdk).getName() : existingSdk.getName()).equals(s)) continue;
            return true;
        }
        return false;
    }

    private void removeSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            PySdkService sdkService = PySdkService.getInstance();
            sdkService.removeSdk(currentSdk);
            this.myProjectSdksModel.removeSdk(currentSdk);
            if (this.myModificators.containsKey(currentSdk)) {
                SdkModificator modificator = this.myModificators.get(currentSdk);
                this.myModifiedModificators.remove(modificator);
                this.myModificators.remove(currentSdk);
            }
            this.refreshSdkList();
            this.mySdkListChanged = true;
            if (this.mySdkList.getSelectedIndex() < 0) {
                this.mySdkList.setSelectedIndex(0);
            }
        }
    }

    private void reloadSdk() {
        Sdk currentSdk = this.getSelectedSdk();
        if (currentSdk != null) {
            this.myModifiedModificators.add(this.myModificators.get(currentSdk));
            this.reloadSdk(currentSdk);
        }
    }

    private void reloadSdk(Sdk currentSdk) {
        PythonSdkType.setupSdkPaths(this.myProject, null, currentSdk, this.myModificators.get(currentSdk));
    }

    private PythonPathEditor createPathEditor(final Sdk sdk) {
        if (PySdkUtil.isRemote(sdk)) {
            return new PythonPathEditor("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor()){
                private final PyRemoteSdkAdditionalDataBase myRemoteSdkData;
                {
                    super(x0, x1, x2);
                    this.myRemoteSdkData = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
                }

                @Override
                protected void onReloadButtonClicked() {
                    PythonSdkDetailsDialog.this.reloadSdk();
                }

                @Override
                protected String getPresentablePath(VirtualFile value) {
                    String path = value.getPath();
                    return this.myRemoteSdkData.getPathMappings().convertToRemote(path);
                }

                @Override
                protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
                    toolbarDecorator.setAddActionUpdater(new AnActionButtonUpdater(){

                        public boolean isEnabled(AnActionEvent e) {
                            return false;
                        }
                    });
                }
            };
        }
        return new PythonPathEditor("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor()){

            @Override
            protected void onReloadButtonClicked() {
                PythonSdkDetailsDialog.this.reloadSdk();
            }
        };
    }

    private class ShowPathButton
    extends AnActionButton
    implements DumbAware {
        public ShowPathButton() {
            super("Show paths for the selected interpreter", AllIcons.Actions.ShowAsTree);
        }

        public boolean isEnabled() {
            return PythonSdkDetailsDialog.this.getSelectedSdk() != null;
        }

        public void actionPerformed(AnActionEvent e) {
            Sdk sdk = PythonSdkDetailsDialog.this.getSelectedSdk();
            if (sdk instanceof PyDetectedSdk) {
                final String sdkName = sdk.getName();
                VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                    public VirtualFile compute() {
                        return LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkName);
                    }
                });
                sdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, PythonSdkType.getInstance(), true, null, null);
            }
            PythonPathEditor pathEditor = PythonSdkDetailsDialog.this.createPathEditor(sdk);
            SdkModificator sdkModificator = (SdkModificator)PythonSdkDetailsDialog.this.myModificators.get(sdk);
            PythonPathDialog dialog = new PythonPathDialog(PythonSdkDetailsDialog.this.myProject, pathEditor);
            pathEditor.reset((SdkModificator)(sdk != null ? sdkModificator : null));
            dialog.show();
            if (dialog.isOK() && pathEditor.isModified()) {
                pathEditor.apply(sdkModificator);
                PythonSdkDetailsDialog.this.myModifiedModificators.add(sdkModificator);
            }
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }

    private class ToggleVirtualEnvFilterButton
    extends ToggleActionButton
    implements DumbAware {
        public ToggleVirtualEnvFilterButton() {
            super("Show virtual environments associated with other projects", AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return PythonSdkDetailsDialog.this.myShowOtherProjectVirtualenvs;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            PythonSdkDetailsDialog.this.myShowOtherProjectVirtualenvs = state2;
            PythonSdkDetailsDialog.this.refreshSdkList();
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }
}

