/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.application.options.ModuleAwareProjectConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.PlatformContentEntriesConfigurable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.configuration.PyContentEntriesModuleConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PythonContentEntriesConfigurable
extends ModuleAwareProjectConfigurable
implements NonDefaultProjectConfigurable,
OptionalConfigurable {
    private final Project myProject;

    public PythonContentEntriesConfigurable(Project project) {
        super(project, "Project Structure", "reference.settingsdialog.project.structure");
        this.myProject = project;
    }

    @Nullable
    private static Module getSingleModule(Project project) {
        return (Module)ArrayUtil.getFirstElement((Object[])ModuleManager.getInstance((Project)project).getModules());
    }

    public boolean needDisplay() {
        return PythonContentEntriesConfigurable.getSingleModule(this.myProject) != null;
    }

    @NotNull
    protected Configurable createModuleConfigurable(Module module) {
        if (PlatformUtils.isPyCharmCommunity()) {
            PlatformContentEntriesConfigurable platformContentEntriesConfigurable = new PlatformContentEntriesConfigurable(module, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE});
            if (platformContentEntriesConfigurable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PythonContentEntriesConfigurable", "createModuleConfigurable"));
            }
            return platformContentEntriesConfigurable;
        }
        PyContentEntriesModuleConfigurable pyContentEntriesModuleConfigurable = new PyContentEntriesModuleConfigurable(module);
        if (pyContentEntriesModuleConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PythonContentEntriesConfigurable", "createModuleConfigurable"));
        }
        return pyContentEntriesModuleConfigurable;
    }
}

