/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Computable;
import com.jetbrains.python.module.PyContentEntriesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyContentEntriesModuleConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private final Module myModule;
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    protected ModifiableRootModel myModifiableModel;
    protected PyContentEntriesEditor myEditor;

    public PyContentEntriesModuleConfigurable(Module module) {
        this.myModule = module;
    }

    public String getDisplayName() {
        return "Project Structure";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure";
    }

    public JComponent createComponent() {
        this.createEditor();
        return this.myTopPanel;
    }

    private void createEditor() {
        if (this.myModule == null) {
            return;
        }
        this.myModifiableModel = (ModifiableRootModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableRootModel>(){

            public ModifiableRootModel compute() {
                return ModuleRootManager.getInstance((Module)PyContentEntriesModuleConfigurable.this.myModule).getModifiableModel();
            }
        });
        ModuleConfigurationStateImpl moduleConfigurationState = new ModuleConfigurationStateImpl(this.myModule.getProject(), (ModulesProvider)new DefaultModulesProvider(this.myModule.getProject())){

            @Override
            public ModifiableRootModel getRootModel() {
                return PyContentEntriesModuleConfigurable.this.myModifiableModel;
            }

            @Override
            public FacetsProvider getFacetsProvider() {
                return DefaultFacetsProvider.INSTANCE;
            }
        };
        this.myEditor = this.createEditor(this.myModule, moduleConfigurationState);
        JComponent component = (JComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JComponent>(){

            public JComponent compute() {
                return PyContentEntriesModuleConfigurable.this.myEditor.createComponent();
            }
        });
        this.myTopPanel.add((Component)component, "Center");
    }

    protected PyContentEntriesEditor createEditor(@NotNull Module module, @NotNull ModuleConfigurationStateImpl state2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/configuration/PyContentEntriesModuleConfigurable", "createEditor"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/configuration/PyContentEntriesModuleConfigurable", "createEditor"));
        }
        return new PyContentEntriesEditor(module, (ModuleConfigurationState)state2, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE});
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor == null) {
            return;
        }
        this.myEditor.apply();
        if (this.myModifiableModel.isChanged()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    PyContentEntriesModuleConfigurable.this.myModifiableModel.commit();
                }
            });
            this.resetEditor();
        }
    }

    public void reset() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.resetEditor();
    }

    private void resetEditor() {
        this.myEditor.disposeUIResources();
        this.myTopPanel.remove(this.myEditor.getComponent());
        this.createEditor();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[0];
    }

    @NotNull
    public String getId() {
        if ("python.project.structure" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PyContentEntriesModuleConfigurable", "getId"));
        }
        return "python.project.structure";
    }
}

