/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyConfigurableInterpreterList {
    private ProjectSdksModel myModel;

    public static PyConfigurableInterpreterList getInstance(Project project) {
        return (PyConfigurableInterpreterList)ServiceManager.getService((Project)project, PyConfigurableInterpreterList.class);
    }

    public ProjectSdksModel getModel() {
        if (this.myModel == null) {
            this.myModel = new ProjectSdksModel();
            this.myModel.reset(null);
        }
        return this.myModel;
    }

    public void disposeModel() {
        if (this.myModel != null) {
            this.myModel.disposeUIResources();
            this.myModel = null;
        }
    }

    public List<Sdk> getAllPythonSdks(final @Nullable Project project) {
        ArrayList<Sdk> result = new ArrayList<Sdk>();
        for (Sdk sdk : this.getModel().getSdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            result.add(sdk);
        }
        Collections.sort(result, new Comparator<Sdk>(){

            @Override
            public int compare(Sdk o1, Sdk o2) {
                if (!(o1.getSdkType() instanceof PythonSdkType) || !(o2.getSdkType() instanceof PythonSdkType)) {
                    return -Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
                }
                boolean isVEnv1 = PythonSdkType.isVirtualEnv(o1);
                boolean isVEnv2 = PythonSdkType.isVirtualEnv(o2);
                boolean isRemote1 = PySdkUtil.isRemote(o1);
                boolean isRemote2 = PySdkUtil.isRemote(o2);
                if (isVEnv1) {
                    if (project != null && PyConfigurableInterpreterList.associatedWithCurrent(o1, project)) {
                        if (PyConfigurableInterpreterList.associatedWithCurrent(o2, project)) {
                            return this.compareSdk(o1, o2);
                        }
                        return -1;
                    }
                    if (isVEnv2) {
                        return this.compareSdk(o1, o2);
                    }
                    return -1;
                }
                if (isVEnv2) {
                    return 1;
                }
                if (isRemote1) {
                    return 1;
                }
                if (isRemote2) {
                    return -1;
                }
                return this.compareSdk(o1, o2);
            }

            private int compareSdk(Sdk o1, Sdk o2) {
                PythonSdkFlavor flavor2;
                LanguageLevel level2;
                PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor(o1);
                LanguageLevel level1 = flavor1 != null ? flavor1.getLanguageLevel(o1) : LanguageLevel.getDefault();
                int compare = Comparing.compare((Comparable)((Object)level1), (Comparable)((Object)(level2 = (flavor2 = PythonSdkFlavor.getFlavor(o2)) != null ? flavor2.getLanguageLevel(o2) : LanguageLevel.getDefault())));
                if (compare != 0) {
                    return -compare;
                }
                return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
        });
        final PySdkService sdkService = PySdkService.getInstance();
        ArrayList<String> sdkHomes = new ArrayList<String>();
        sdkHomes.addAll(VirtualEnvSdkFlavor.INSTANCE.suggestHomePaths());
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (flavor instanceof VirtualEnvSdkFlavor) continue;
            sdkHomes.addAll(flavor.suggestHomePaths());
        }
        Collections.sort(sdkHomes);
        for (String sdkHome : SdkConfigurationUtil.filterExistingPaths(PythonSdkType.getInstance(), sdkHomes, this.getModel().getSdks())) {
            result.add(new PyDetectedSdk(sdkHome));
        }
        for (String sdkHome : SdkConfigurationUtil.filterExistingPaths(PythonSdkType.getInstance(), sdkService.getAddedSdks(), this.getModel().getSdks())) {
            result.add(new PyDetectedSdk(sdkHome));
        }
        Iterables.removeIf(result, (Predicate)new Predicate<Sdk>(){

            public boolean apply(@Nullable Sdk input) {
                return input != null && sdkService.isRemoved(input);
            }
        });
        return result;
    }

    private static boolean associatedWithCurrent(Sdk o1, Project project) {
        PythonSdkAdditionalData data = (PythonSdkAdditionalData)o1.getSdkAdditionalData();
        if (data != null) {
            String path = data.getAssociatedProjectPath();
            String projectBasePath = project.getBasePath();
            if (path != null && path.equals(projectBasePath)) {
                return true;
            }
        }
        return false;
    }

    public List<Sdk> getAllPythonSdks() {
        return this.getAllPythonSdks(null);
    }
}

