/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.application.options.ModuleAwareProjectConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.jetbrains.python.configuration.PyActiveSdkConfigurable;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import org.jetbrains.annotations.NotNull;

public class PyActiveSdkModuleConfigurable
extends ModuleAwareProjectConfigurable {
    private final Project myProject;

    public PyActiveSdkModuleConfigurable(Project project) {
        super(project, "Project Interpreter", "reference.settings.project.interpreter");
        this.myProject = project;
    }

    @NotNull
    protected UnnamedConfigurable createModuleConfigurable(Module module) {
        PyActiveSdkConfigurable pyActiveSdkConfigurable = new PyActiveSdkConfigurable(module);
        if (pyActiveSdkConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PyActiveSdkModuleConfigurable", "createModuleConfigurable"));
        }
        return pyActiveSdkConfigurable;
    }

    protected UnnamedConfigurable createDefaultProjectConfigurable() {
        return new PyActiveSdkConfigurable(this.myProject);
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null) continue;
            VFSTestFrameworkListener.getInstance().updateAllTestFrameworks(sdk);
            break;
        }
        PythonSdkUpdater.getInstance().updateActiveSdks(this.myProject, 0);
    }
}

