/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.NullableConsumer;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonSdkDetailsDialog;
import com.jetbrains.python.configuration.VirtualEnvProjectFilter;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyActiveSdkConfigurable
implements UnnamedConfigurable {
    private JPanel myMainPanel;
    private final Project myProject;
    @Nullable
    private final Module myModule;
    private MySdkModelListener mySdkModelListener;
    private PyConfigurableInterpreterList myInterpreterList;
    private ProjectSdksModel myProjectSdksModel;
    private ComboBox mySdkCombo;
    private PyInstalledPackagesPanel myPackagesPanel;
    private JButton myDetailsButton;
    private static final String SHOW_ALL = "Show All";
    private NullableConsumer<Sdk> myDetailsCallback;

    public PyActiveSdkConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/configuration/PyActiveSdkConfigurable", "<init>"));
        }
        this.myModule = null;
        this.myProject = project;
        this.layoutPanel();
        this.initContent();
    }

    public PyActiveSdkConfigurable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/configuration/PyActiveSdkConfigurable", "<init>"));
        }
        this.myModule = module;
        this.myProject = module.getProject();
        this.layoutPanel();
        this.initContent();
    }

    private void initContent() {
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.mySdkModelListener = new MySdkModelListener(this);
        this.myProjectSdksModel.addListener(this.mySdkModelListener);
        this.mySdkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk selectedSdk = (Sdk)PyActiveSdkConfigurable.this.mySdkCombo.getSelectedItem();
                PyActiveSdkConfigurable.this.myPackagesPanel.updatePackages(selectedSdk != null ? new PyPackageManagementService(PyActiveSdkConfigurable.this.myProject, selectedSdk) : null);
                PyActiveSdkConfigurable.this.myPackagesPanel.updateNotifications(selectedSdk);
            }
        });
        this.myDetailsCallback = new NullableConsumer<Sdk>(){

            public void consume(@Nullable Sdk sdk) {
                Sdk moduleSdk = PyActiveSdkConfigurable.this.getSdk();
                if (sdk instanceof PyDetectedSdk) {
                    Sdk addedSdk = SdkConfigurationUtil.setupSdk(PyActiveSdkConfigurable.this.myProjectSdksModel.getSdks(), sdk.getHomeDirectory(), PythonSdkType.getInstance(), true, null, null);
                    PyActiveSdkConfigurable.this.myProjectSdksModel.addSdk(addedSdk);
                    PyActiveSdkConfigurable.this.updateSdkList(false);
                    if (addedSdk != null) {
                        PyActiveSdkConfigurable.this.mySdkCombo.getModel().setSelectedItem(PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(addedSdk.getName()));
                    }
                } else if (moduleSdk != null && PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(moduleSdk) != sdk && sdk != null) {
                    PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)sdk.getSdkAdditionalData();
                    if (additionalData != null) {
                        String path = additionalData.getAssociatedProjectPath();
                        String basePath = PyActiveSdkConfigurable.this.myProject.getBasePath();
                        if (basePath != null && !basePath.equals(path)) {
                            additionalData.setAssociatedProjectPath(null);
                        }
                    }
                    PyActiveSdkConfigurable.this.updateSdkList(false);
                    PyActiveSdkConfigurable.this.mySdkCombo.getModel().setSelectedItem(PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk.getName()));
                }
            }
        };
        this.myDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkDetailsStep.show(PyActiveSdkConfigurable.this.myProject, PyActiveSdkConfigurable.this.myProjectSdksModel.getSdks(), PyActiveSdkConfigurable.this.myModule == null ? new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myProject, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myDetailsCallback) : new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myModule, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myDetailsCallback), PyActiveSdkConfigurable.this.myMainPanel, PyActiveSdkConfigurable.this.myDetailsButton.getLocationOnScreen(), new NullableConsumer<Sdk>(){

                    public void consume(Sdk sdk) {
                        if (sdk == null) {
                            return;
                        }
                        PySdkService sdkService = PySdkService.getInstance();
                        sdkService.restoreSdk(sdk);
                        if (PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk) == null) {
                            PyActiveSdkConfigurable.this.myProjectSdksModel.addSdk(sdk);
                        }
                        PyActiveSdkConfigurable.this.updateSdkList(false);
                        PyActiveSdkConfigurable.this.mySdkCombo.getModel().setSelectedItem(PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk.getName()));
                        PyActiveSdkConfigurable.this.myPackagesPanel.updatePackages(new PyPackageManagementService(PyActiveSdkConfigurable.this.myProject, sdk));
                        PyActiveSdkConfigurable.this.myPackagesPanel.updateNotifications(sdk);
                    }
                });
            }
        });
    }

    private void layoutPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.myMainPanel = new JPanel(layout);
        JLabel interpreterLabel = new JLabel("Project Interpreter:");
        JLabel emptyLabel = new JLabel("  ");
        this.mySdkCombo = new ComboBox(){

            public void setSelectedItem(Object item) {
                if (PyActiveSdkConfigurable.SHOW_ALL.equals(item)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PythonSdkDetailsDialog options = PyActiveSdkConfigurable.this.myModule == null ? new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myProject, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myDetailsCallback) : new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myModule, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myDetailsCallback);
                            options.show();
                        }
                    });
                    return;
                }
                if (!"separator".equals(item)) {
                    super.setSelectedItem(item);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics g) {
                try {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.paint(g);
                }
                finally {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
            }
        };
        this.mySdkCombo.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(false)));
        PackagesNotificationPanel notificationsArea = new PackagesNotificationPanel();
        JComponent notificationsComponent = notificationsArea.getComponent();
        Dimension preferredSize = this.mySdkCombo.getPreferredSize();
        this.mySdkCombo.setPreferredSize(preferredSize);
        notificationsArea.hide();
        this.myDetailsButton = new FixedSizeButton();
        this.myDetailsButton.setIcon(PythonIcons.Python.InterpreterGear);
        this.myDetailsButton.setPreferredSize(new Dimension(preferredSize.height, preferredSize.height));
        this.myPackagesPanel = new PyInstalledPackagesPanel(this.myProject, notificationsArea);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.myMainPanel.add((Component)interpreterLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        this.myMainPanel.add((Component)this.mySdkCombo, c);
        c.insets = new Insets(2, 0, 2, 2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)this.myDetailsButton, c);
        c.insets = new Insets(2, 2, 0, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        this.myMainPanel.add((Component)emptyLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = -1;
        c.fill = 1;
        this.myMainPanel.add((Component)this.myPackagesPanel, c);
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        this.myMainPanel.add((Component)notificationsComponent, c);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        Sdk selectedItem = (Sdk)this.mySdkCombo.getSelectedItem();
        Sdk sdk = this.getSdk();
        sdk = sdk == null ? null : this.myProjectSdksModel.findSdk(sdk.getName());
        return selectedItem instanceof PyDetectedSdk || sdk != selectedItem;
    }

    @Nullable
    private Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    public void apply() throws ConfigurationException {
        Sdk item;
        Sdk newSdk = item = (Sdk)this.mySdkCombo.getSelectedItem();
        if (item instanceof PyDetectedSdk) {
            VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath(item.getName());
                }
            });
            newSdk = SdkConfigurationUtil.setupSdk(this.myProjectSdksModel.getSdks(), sdkHome, PythonSdkType.getInstance(), true, null, null);
            if (newSdk != null) {
                this.myProjectSdksModel.addSdk(newSdk);
                this.updateSdkList(false);
            }
            PySdkService.getInstance().solidifySdk(item);
        }
        this.myProjectSdksModel.apply();
        newSdk = newSdk == null ? null : this.myProjectSdksModel.findSdk(newSdk.getName());
        this.mySdkCombo.getModel().setSelectedItem(newSdk);
        Sdk prevSdk = this.getSdk();
        this.setSdk(newSdk);
        if (prevSdk != null && newSdk != null) {
            PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor(newSdk);
            PythonSdkFlavor flavor2 = PythonSdkFlavor.getFlavor(prevSdk);
            if (flavor1 != null && flavor2 != null) {
                LanguageLevel languageLevel1 = flavor1.getLanguageLevel(newSdk);
                LanguageLevel languageLevel2 = flavor2.getLanguageLevel(prevSdk);
                if (languageLevel1.isPy3K() && languageLevel2.isPy3K() || !languageLevel1.isPy3K() && !languageLevel2.isPy3K()) {
                    return;
                }
            }
        }
        PyActiveSdkConfigurable.rehighlightStrings(this.myProject);
    }

    private void setSdk(final Sdk item) {
        final ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                rootManager.setProjectSdk(item);
            }
        });
        if (this.myModule != null) {
            ModuleRootModificationUtil.setModuleSdk(this.myModule, item);
        }
    }

    public static void rehighlightStrings(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/configuration/PyActiveSdkConfigurable", "rehighlightStrings"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                    VirtualFile vFile;
                    if (!(editor instanceof EditorEx) || editor.getProject() != project || (vFile = ((EditorEx)editor).getVirtualFile()) == null) continue;
                    EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, vFile);
                    ((EditorEx)editor).setHighlighter(highlighter);
                }
            }
        });
    }

    public void reset() {
        this.resetSdkList();
    }

    private void resetSdkList() {
        this.updateSdkList(false);
        Sdk sdk = this.getSdk();
        this.mySdkCombo.getModel().setSelectedItem(sdk == null ? null : this.myProjectSdksModel.findSdk(sdk.getName()));
        this.myPackagesPanel.updatePackages(sdk != null ? new PyPackageManagementService(this.myProject, sdk) : null);
        this.myPackagesPanel.updateNotifications(sdk);
    }

    private void updateSdkList(boolean preserveSelection) {
        Sdk selection;
        List<Sdk> sdkList = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk sdk = selection = preserveSelection ? (Sdk)this.mySdkCombo.getSelectedItem() : null;
        if (!sdkList.contains(selection)) {
            selection = null;
        }
        VirtualEnvProjectFilter.removeNotMatching(this.myProject, sdkList);
        if (selection != null && !sdkList.contains(selection)) {
            sdkList.add(0, selection);
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(null);
        boolean remoteSeparator = true;
        boolean separator = true;
        boolean detectedSeparator = true;
        for (Sdk sdk2 : sdkList) {
            if (!PythonSdkType.isVirtualEnv(sdk2) && !PythonSdkType.isRemote(sdk2) && !(sdk2 instanceof PyDetectedSdk) && separator) {
                items.add("separator");
                separator = false;
            }
            if (PythonSdkType.isRemote(sdk2) && remoteSeparator) {
                items.add("separator");
                remoteSeparator = false;
            }
            if (sdk2 instanceof PyDetectedSdk && detectedSeparator) {
                items.add("separator");
                detectedSeparator = false;
            }
            items.add((String)sdk2);
        }
        items.add("separator");
        items.add(SHOW_ALL);
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(false)));
        this.mySdkCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)selection));
    }

    public void disposeUIResources() {
        this.myProjectSdksModel.removeListener(this.mySdkModelListener);
        this.myInterpreterList.disposeModel();
    }

    private static class MySdkModelListener
    implements SdkModel.Listener {
        private final PyActiveSdkConfigurable myConfigurable;

        public MySdkModelListener(PyActiveSdkConfigurable configurable) {
            this.myConfigurable = configurable;
        }

        public void sdkAdded(Sdk sdk) {
            this.myConfigurable.updateSdkList(true);
        }

        public void beforeSdkRemove(Sdk sdk) {
            this.myConfigurable.updateSdkList(true);
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            this.myConfigurable.updateSdkList(true);
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
        }
    }
}

