/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableFunction;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class EditSdkDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myNameTextField;
    private TextFieldWithBrowseButton myInterpreterPathTextField;
    private JBCheckBox myAssociateCheckbox;
    private JBLabel myRemoveAssociationLabel;
    private final boolean myWasAssociated;
    private boolean myAssociationRemoved = false;

    protected EditSdkDialog(Project project, SdkModificator sdk, final NullableFunction<String, String> nameValidator) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle("Edit Python Interpreter");
        this.myNameTextField.setText(sdk.getName());
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String nameError = (String)nameValidator.fun((Object)EditSdkDialog.this.getName());
                EditSdkDialog.this.setErrorText(nameError);
                EditSdkDialog.this.setOKActionEnabled(nameError == null);
            }
        });
        this.myInterpreterPathTextField.setText(sdk.getHomePath());
        this.myInterpreterPathTextField.addBrowseFolderListener("Specify Interpreter Path", null, project, PythonSdkType.getInstance().getHomeChooserDescriptor());
        this.myRemoveAssociationLabel.setVisible(false);
        if (PythonSdkType.getVirtualEnvRoot(sdk.getHomePath()) == null) {
            this.myAssociateCheckbox.setVisible(false);
        } else {
            String path;
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)sdk.getSdkAdditionalData();
            if (data != null && (path = data.getAssociatedProjectPath()) != null) {
                this.myAssociateCheckbox.setSelected(true);
                String basePath = project.getBasePath();
                if (basePath != null && !path.equals(FileUtil.toSystemIndependentName((String)basePath))) {
                    this.myAssociateCheckbox.setEnabled(false);
                    this.myAssociateCheckbox.setText("Associate this virtual environment with " + FileUtil.toSystemDependentName((String)path));
                    this.myRemoveAssociationLabel.setVisible(true);
                }
            }
        }
        this.myWasAssociated = this.myAssociateCheckbox.isSelected();
        this.init();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/EditSdkDialog$2", "onClick"));
                }
                EditSdkDialog.this.myAssociateCheckbox.setSelected(false);
                EditSdkDialog.this.myAssociateCheckbox.setEnabled(true);
                EditSdkDialog.this.myAssociateCheckbox.setText("Associate this environment with current project");
                EditSdkDialog.this.myRemoveAssociationLabel.setVisible(false);
                EditSdkDialog.this.myAssociationRemoved = true;
                return true;
            }
        }.installOn((Component)this.myRemoveAssociationLabel);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    public String getName() {
        return this.myNameTextField.getText();
    }

    public String getHomePath() {
        return this.myInterpreterPathTextField.getText();
    }

    public boolean associateWithProject() {
        return this.myAssociateCheckbox.isSelected();
    }

    public boolean isAssociateChanged() {
        return this.myWasAssociated != this.associateWithProject() || this.myAssociationRemoved;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jTextField.setColumns(100);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Interpreter path:");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAssociateCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Associate this virtual environment with current project");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jBCheckBox.setSelected(false);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myRemoveAssociationLabel = jBLabel = new JBLabel();
        jBLabel.setVisible(true);
        jBLabel.setText("<html><a href=\"#\">Remove association</a>");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

