/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUserSkeletonsUtil {
    public static final String USER_SKELETONS_DIR = "python-skeletons";
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil");
    public static final Key<Boolean> HAS_SKELETON = Key.create((String)"PyUserSkeleton.hasSkeleton");
    @Nullable
    private static VirtualFile ourUserSkeletonsDirectory;
    private static boolean ourNoSkeletonsErrorReported;

    @NotNull
    private static List<String> getPossibleUserSkeletonsPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PathManager.getConfigPath() + File.separator + USER_SKELETONS_DIR);
        result.add(ApplicationManager.getApplication().isInternal() ? StringUtil.join((String[])new String[]{PythonHelpersLocator.getPythonCommunityPath(), "helpers", USER_SKELETONS_DIR}, (String)File.separator) : PythonHelpersLocator.getHelperPath(USER_SKELETONS_DIR));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getPossibleUserSkeletonsPaths"));
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile getUserSkeletonsDirectory() {
        if (ourUserSkeletonsDirectory == null) {
            for (String path : PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths()) {
                ourUserSkeletonsDirectory = LocalFileSystem.getInstance().findFileByPath(path);
                if (ourUserSkeletonsDirectory == null) continue;
                break;
            }
        }
        if (!ourNoSkeletonsErrorReported && ourUserSkeletonsDirectory == null) {
            ourNoSkeletonsErrorReported = true;
            LOG.warn("python-skeletons directory not found in paths: " + PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths());
        }
        return ourUserSkeletonsDirectory;
    }

    public static boolean isUnderUserSkeletonsDirectory(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "isUnderUserSkeletonsDirectory"));
        }
        VirtualFile skeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory();
        VirtualFile virtualFile = file.getVirtualFile();
        return skeletonsDir != null && virtualFile != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    @Nullable
    public static <T extends PyElement> T getUserSkeleton(@NotNull T element) {
        PyFile skeletonFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeleton"));
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && (skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForFile((PyFile)file)) != null && skeletonFile != file) {
            PsiElement skeletonElement = PyUserSkeletonsUtil.getUserSkeleton(element, skeletonFile);
            if (element.getClass().isInstance(skeletonElement) && skeletonElement != element) {
                return (T)((PyElement)skeletonElement);
            }
        }
        return null;
    }

    @Nullable
    public static PyFile getUserSkeletonForModuleQName(@NotNull String qName, @NotNull PsiElement foothold) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeletonForModuleQName"));
        }
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeletonForModuleQName"));
        }
        Sdk sdk = PythonSdkType.getSdk(foothold);
        if (sdk != null) {
            VirtualFile directory;
            QualifiedName cacheQName;
            Project project = foothold.getProject();
            PythonSdkPathCache cache = PythonSdkPathCache.getInstance(project, sdk);
            List<PsiElement> results = cache.get(cacheQName = QualifiedName.fromDottedString((String)("python-skeletons." + qName)));
            if (results != null) {
                PsiElement element;
                PsiElement psiElement = element = results.isEmpty() ? null : results.get(0);
                if (element instanceof PyFile) {
                    return (PyFile)element;
                }
            }
            if ((directory = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(directory);
                PsiElement fileSkeleton = new QualifiedNameResolverImpl(qName).resolveModuleAt(psiDirectory);
                if (fileSkeleton instanceof PsiDirectory) {
                    fileSkeleton = PyUtil.getPackageElement((PsiDirectory)fileSkeleton, foothold);
                }
                if (fileSkeleton instanceof PyFile) {
                    cache.put(cacheQName, Collections.singletonList(fileSkeleton));
                    return (PyFile)fileSkeleton;
                }
            }
            cache.put(cacheQName, Collections.<PsiElement>emptyList());
        }
        return null;
    }

    public static void addUserSkeletonsRoot(@NotNull SdkModificator sdkModificator) {
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "addUserSkeletonsRoot"));
        }
        VirtualFile root = PyUserSkeletonsUtil.getUserSkeletonsDirectory();
        if (root != null) {
            sdkModificator.addRoot(root, OrderRootType.CLASSES);
        }
    }

    @Nullable
    private static PsiElement getUserSkeleton(@NotNull PyElement element, @NotNull PyFile skeletonFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeleton"));
        }
        if (skeletonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skeletonFile", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeleton"));
        }
        if (element instanceof PyFile) {
            return skeletonFile;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
        String name = element.getName();
        if (owner != null && name != null) {
            assert (owner != element);
            PsiElement originalOwner = PyUserSkeletonsUtil.getUserSkeleton(owner, skeletonFile);
            if (originalOwner instanceof PyClass) {
                PyClassLikeType classType;
                PyClassLikeType instanceType;
                List<? extends RatedResolveResult> resolveResults;
                PyClass classOwner = (PyClass)originalOwner;
                PyType type = TypeEvalContext.codeInsightFallback(classOwner.getProject()).getType(classOwner);
                if (type instanceof PyClassLikeType && (resolveResults = (instanceType = (classType = (PyClassLikeType)type).toInstance()).resolveMember(name, null, AccessDirection.READ, PyResolveContext.noImplicits(), false)) != null && !resolveResults.isEmpty()) {
                    return resolveResults.get(0).getElement();
                }
            } else if (originalOwner instanceof NameDefiner) {
                return ((NameDefiner)originalOwner).getElementNamed(name);
            }
        }
        return null;
    }

    @Nullable
    private static PyFile getUserSkeletonForFile(@NotNull PyFile file) {
        String moduleName;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil", "getUserSkeletonForFile"));
        }
        Boolean hasSkeleton = (Boolean)file.getUserData(HAS_SKELETON);
        if (hasSkeleton != null && !hasSkeleton.booleanValue()) {
            return null;
        }
        VirtualFile moduleVirtualFile = file.getVirtualFile();
        if (moduleVirtualFile != null && (moduleName = QualifiedNameFinder.findShortestImportableName(file, moduleVirtualFile)) != null) {
            QualifiedName qName = QualifiedName.fromDottedString((String)moduleName);
            for (PyCanonicalPathProvider provider : (PyCanonicalPathProvider[])Extensions.getExtensions(PyCanonicalPathProvider.EP_NAME)) {
                QualifiedName restored = provider.getCanonicalPath(qName, null);
                if (restored == null) continue;
                moduleName = restored.toString();
            }
            PyFile skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForModuleQName(moduleName, file);
            file.putUserData(HAS_SKELETON, skeletonFile != null);
            return skeletonFile;
        }
        return null;
    }

    static {
        ourNoSkeletonsErrorReported = false;
    }
}

