/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.PyModuleMembersProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class PyUserSkeletonsModuleMembersProvider
extends PyModuleMembersProvider {
    @Override
    @Nullable
    public PsiElement resolveMember(PyFile module, String name) {
        PyFile moduleSkeleton = PyUserSkeletonsUtil.getUserSkeleton(module);
        if (moduleSkeleton != null) {
            return moduleSkeleton.getElementNamed(name);
        }
        return null;
    }

    @Override
    protected Collection<PyCustomMember> getMembersByQName(PyFile module, String qName) {
        PyFile moduleSkeleton = PyUserSkeletonsUtil.getUserSkeletonForModuleQName(qName, module);
        if (moduleSkeleton != null) {
            ArrayList<PyCustomMember> results = new ArrayList<PyCustomMember>();
            for (PyElement element : moduleSkeleton.iterateNames()) {
                String name;
                if (element instanceof PsiFileSystemItem || (name = element.getName()) == null) continue;
                results.add(new PyCustomMember(name, (PsiElement)element));
            }
            return results;
        }
        return Collections.emptyList();
    }
}

