/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUserSkeletonsLineMarkerProvider
implements LineMarkerProvider {
    public static final Icon ICON = AllIcons.Gutter.Unique;

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsLineMarkerProvider", "collectSlowLineMarkers"));
        }
        for (PsiElement element : elements) {
            PyElement skeleton = PyUserSkeletonsLineMarkerProvider.getUserSkeleton(element);
            if (skeleton == null) continue;
            result.add(new LineMarkerInfo(element, element.getTextRange(), ICON, 6, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement e) {
                    return "Has user skeleton";
                }
            }, (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

                public void navigate(MouseEvent e, PsiElement elt) {
                    PyElement s = PyUserSkeletonsLineMarkerProvider.getUserSkeleton(elt);
                    if (s != null) {
                        PsiNavigateUtil.navigate((PsiElement)s);
                    }
                }
            }, GutterIconRenderer.Alignment.RIGHT));
        }
    }

    @Nullable
    private static PyElement getUserSkeleton(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsLineMarkerProvider", "getUserSkeleton"));
        }
        if (element instanceof PyFunction || element instanceof PyTargetExpression) {
            return PyUserSkeletonsUtil.getUserSkeleton((PyElement)element);
        }
        return null;
    }
}

