/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUserSkeletonsClassMembersProvider
extends PyClassMembersProviderBase
implements PyOverridingAncestorsClassMembersProvider {
    @Override
    @NotNull
    public Collection<PyCustomMember> getMembers(@NotNull PyClassType classType, PsiElement location) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "getMembers"));
        }
        PyClass cls = classType.getPyClass();
        PyClass skeleton = PyUserSkeletonsUtil.getUserSkeleton(cls);
        if (skeleton != null) {
            Collection<PyCustomMember> collection = PyUserSkeletonsClassMembersProvider.getClassMembers(skeleton);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "getMembers"));
            }
            return collection;
        }
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "getMembers"));
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement resolveMember(@NotNull PyClassType classType, @NotNull String name, PsiElement location) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "resolveMember"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "resolveMember"));
        }
        PyClass cls = classType.getPyClass();
        PyClass skeleton = PyUserSkeletonsUtil.getUserSkeleton(cls);
        if (skeleton != null) {
            return PyUserSkeletonsClassMembersProvider.findClassMember(skeleton, name);
        }
        return null;
    }

    private static PsiElement findClassMember(@NotNull PyClass cls, @NotNull String name) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "findClassMember"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "findClassMember"));
        }
        PyFunction function = cls.findMethodByName(name, false);
        if (function != null) {
            return function;
        }
        PyTargetExpression instanceAttribute = cls.findInstanceAttribute(name, false);
        if (instanceAttribute != null) {
            return instanceAttribute;
        }
        PyTargetExpression classAttribute = cls.findClassAttribute(name, false);
        if (classAttribute != null) {
            return classAttribute;
        }
        return null;
    }

    private static Collection<PyCustomMember> getClassMembers(@NotNull PyClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsClassMembersProvider", "getClassMembers"));
        }
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        for (PyFunction function : cls.getMethods(false)) {
            String name = function.getName();
            if (name == null) continue;
            result.add(new PyCustomMember(name, function));
        }
        for (PyTargetExpression attribute : cls.getInstanceAttributes()) {
            String name = attribute.getName();
            if (name == null) continue;
            result.add(new PyCustomMember(name, (PsiElement)attribute));
        }
        for (PyTargetExpression attribute : cls.getClassAttributes()) {
            String name = attribute.getName();
            if (name == null) continue;
            result.add(new PyCustomMember(name, (PsiElement)attribute));
        }
        return result;
    }
}

