/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.doctest.PythonDocTestUtil;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyTestFinder
implements TestFinder {
    public PyDocStringOwner findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findSourceElement"));
        }
        return (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyClass.class, PyFunction.class});
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findTestsForClass"));
        }
        PyDocStringOwner source = this.findSourceElement(element);
        if (source == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findTestsForClass"));
            }
            return set;
        }
        String sourceName = source.getName();
        if (sourceName == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findTestsForClass"));
            }
            return set;
        }
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithProximities = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        if (source instanceof PyClass) {
            Collection<String> names = PyClassNameIndex.allKeys(element.getProject());
            for (String eachName : names) {
                if (!eachName.contains(sourceName)) continue;
                for (PyClass eachClass : PyClassNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestUtil.isTestCaseClass(eachClass) && !PythonDocTestUtil.isDocTestClass(eachClass)) continue;
                    classesWithProximities.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity(sourceName, eachName)));
                }
            }
        } else {
            Collection<String> names = PyFunctionNameIndex.allKeys(element.getProject());
            for (String eachName : names) {
                if (!eachName.contains(sourceName)) continue;
                for (PyFunction eachFunction : PyFunctionNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestUtil.isTestCaseFunction(eachFunction) && !PythonDocTestUtil.isDocTestFunction(eachFunction)) continue;
                    classesWithProximities.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachFunction, (Object)TestFinderHelper.calcTestNameProximity(sourceName, eachName)));
                }
            }
        }
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithProximities, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findTestsForClass"));
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findClassesForTest"));
        }
        PyFunction sourceFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        PyClass source = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (sourceFunction == null && source == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findClassesForTest"));
            }
            return set;
        }
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithWeights = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        ArrayList<Pair<String, Integer>> possibleNames = new ArrayList<Pair<String, Integer>>();
        if (source != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights(source.getName()));
        }
        if (sourceFunction != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights(sourceFunction.getName()));
        }
        for (Pair pair : possibleNames) {
            for (PyClass eachClass : PyClassNameIndex.find((String)pair.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PyTestUtil.isPyTestClass(eachClass)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, pair.second));
            }
            for (PyFunction function : PyFunctionNameIndex.find((String)pair.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PyTestUtil.isPyTestFunction(function)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)function, pair.second));
            }
        }
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithWeights, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "findClassesForTest"));
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder", "isTest"));
        }
        PyClass cl = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (cl != null) {
            return PyTestUtil.isPyTestClass(cl);
        }
        return false;
    }
}

