/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestAction;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;

public class PyTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.testIntegration.PyTestCreator");

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        CreateTestAction action = new CreateTestAction();
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null) {
            return action.isAvailable(project, editor, element);
        }
        return false;
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (action.isAvailable(project, editor, element)) {
                action.invoke(project, editor, file.getContainingFile());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static PsiFile generateTest(final Project project, final CreateTestDialog dialog) {
        return PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Computable<PsiFile>(){

            public PsiFile compute() {
                return (PsiFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        try {
                            IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
                            String fileName = dialog.getFileName();
                            if (!fileName.endsWith(".py")) {
                                fileName = fileName + "." + PythonFileType.INSTANCE.getDefaultExtension();
                            }
                            StringBuilder fileText = new StringBuilder();
                            fileText.append("class ").append(dialog.getClassName()).append("(TestCase):\n  ");
                            List<String> methods = dialog.getMethods();
                            if (methods.size() == 0) {
                                fileText.append("pass\n");
                            }
                            for (String method : methods) {
                                fileText.append("def ").append(method).append("(self):\n    self.fail()\n\n  ");
                            }
                            PyFile psiFile = PyUtil.getOrCreateFile(dialog.getTargetDir() + "/" + fileName, project);
                            AddImportHelper.addOrUpdateFromImportStatement(psiFile, "unittest", "TestCase", null, AddImportHelper.ImportPriority.BUILTIN, null);
                            PyElement createdClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement(psiFile), PyClass.class, fileText.toString());
                            createdClass = (PyElement)psiFile.addAfter((PsiElement)createdClass, psiFile.getLastChild());
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                            createdClass.navigate(false);
                            return psiFile;
                        }
                        catch (IncorrectOperationException e) {
                            LOG.warn((Throwable)e);
                            return null;
                        }
                    }
                });
            }
        });
    }
}

