/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestDialog;
import com.jetbrains.python.codeInsight.testIntegration.PyTestCreator;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CreateTestAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/testIntegration/CreateTestAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/testIntegration/CreateTestAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/CreateTestAction", "isAvailable"));
        }
        PyClass psiClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        return psiClass == null || !PyTestUtil.isPyTestClass(psiClass);
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/testIntegration/CreateTestAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/testIntegration/CreateTestAction", "invoke"));
        }
        PyFunction srcFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        PyClass srcClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (srcClass == null && srcFunction == null) {
            return;
        }
        PsiDirectory dir = element.getContainingFile().getContainingDirectory();
        final CreateTestDialog d = new CreateTestDialog(project);
        if (srcClass != null) {
            d.setClassName("Test" + StringUtil.capitalize((String)srcClass.getName()));
            d.setFileName("test_" + StringUtil.decapitalize((String)srcClass.getName()) + ".py");
            if (dir != null) {
                d.setTargetDir(dir.getVirtualFile().getPath());
            }
            if (srcFunction != null) {
                d.methodsSize(1);
                d.addMethod("test_" + srcFunction.getName(), 0);
            } else {
                final ArrayList methods = Lists.newArrayList();
                srcClass.visitMethods(new Processor<PyFunction>(){

                    public boolean process(PyFunction pyFunction) {
                        if (pyFunction.getName() != null && !pyFunction.getName().startsWith("__")) {
                            methods.add(pyFunction);
                        }
                        return true;
                    }
                }, false);
                d.methodsSize(methods.size());
                int i = 0;
                for (PyFunction f : methods) {
                    d.addMethod("test_" + f.getName(), i);
                    ++i;
                }
            }
        } else {
            d.setClassName("Test" + StringUtil.capitalize((String)srcFunction.getName()));
            d.setFileName("test_" + StringUtil.decapitalize((String)srcFunction.getName()) + ".py");
            if (dir != null) {
                d.setTargetDir(dir.getVirtualFile().getPath());
            }
            d.methodsSize(1);
            d.addMethod("test_" + srcFunction.getName(), 0);
        }
        d.show();
        if (!d.isOK()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                PsiFile e = PyTestCreator.generateTest(project, d);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                documentManager.commitAllDocuments();
            }
        }, CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (Object)this);
    }
}

