/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibCanonicalPathProvider;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStdlibTypeProvider
extends PyTypeProviderBase {
    private static final Set<String> OPEN_FUNCTIONS = ImmutableSet.of((Object)"__builtin__.open", (Object)"io.open", (Object)"os.fdopen", (Object)"pathlib.Path.open");
    private static final String BINARY_FILE_TYPE = "io.FileIO[bytes]";
    private static final String TEXT_FILE_TYPE = "io.TextIOWrapper[unicode]";

    @Nullable
    public static PyStdlibTypeProvider getInstance() {
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            if (!(typeProvider instanceof PyStdlibTypeProvider)) continue;
            return (PyStdlibTypeProvider)typeProvider;
        }
        return null;
    }

    @Override
    public PyType getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceTarget", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getReferenceType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getReferenceType"));
        }
        PyType type = PyStdlibTypeProvider.getBaseStringType(referenceTarget);
        if (type != null) {
            return type;
        }
        type = PyStdlibTypeProvider.getNamedTupleType(referenceTarget, anchor);
        if (type != null) {
            return type;
        }
        type = PyStdlibTypeProvider.getEnumType(referenceTarget, context, anchor);
        if (type != null) {
            return type;
        }
        return null;
    }

    @Nullable
    private static PyType getBaseStringType(@NotNull PsiElement referenceTarget) {
        if (referenceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceTarget", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getBaseStringType"));
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(referenceTarget);
        if (referenceTarget instanceof PyElement && builtinCache.isBuiltin(referenceTarget) && "basestring".equals(((PyElement)referenceTarget).getName())) {
            return builtinCache.getStringType(LanguageLevel.forElement(referenceTarget));
        }
        return null;
    }

    @Nullable
    private static PyType getEnumType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyTargetExpression target;
        ScopeOwner owner;
        if (referenceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceTarget", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getEnumType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getEnumType"));
        }
        if (referenceTarget instanceof PyTargetExpression && (owner = ScopeUtil.getScopeOwner((PsiElement)(target = (PyTargetExpression)referenceTarget))) instanceof PyClass) {
            PyClass cls = (PyClass)owner;
            List<PyClassLikeType> types = cls.getAncestorTypes(context);
            for (PyClassLikeType type : types) {
                PyType classType;
                if (type == null || !"enum.Enum".equals(type.getClassQName()) || !((classType = context.getType(cls)) instanceof PyClassType)) continue;
                return ((PyClassType)classType).toInstance();
            }
        }
        if (referenceTarget instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)referenceTarget;
            String name = qualifiedNameOwner.getQualifiedName();
            if ("enum.Enum.name".equals(name)) {
                return PyBuiltinCache.getInstance(referenceTarget).getStrType();
            }
            if ("enum.Enum.value".equals(name) && anchor instanceof PyReferenceExpression && context.maySwitchToAST(anchor)) {
                PyExpression value;
                PyTargetExpression qualifierTarget;
                PyReferenceExpression qualifierExpr;
                PsiElement resolvedQualifier;
                PyReferenceExpression anchorExpr = (PyReferenceExpression)anchor;
                PyExpression qualifier = anchorExpr.getQualifier();
                if (qualifier instanceof PyReferenceExpression && (resolvedQualifier = (qualifierExpr = (PyReferenceExpression)qualifier).getReference().resolve()) instanceof PyTargetExpression && context.maySwitchToAST((PsiElement)(qualifierTarget = (PyTargetExpression)resolvedQualifier)) && (value = qualifierTarget.findAssignedValue()) != null) {
                    return context.getType(value);
                }
            } else if ("enum.EnumMeta.__members__".equals(name)) {
                return PyTypeParser.getTypeByName(referenceTarget, "dict[str, unknown]");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull PyFunction function, @Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getCallType"));
        }
        String qname = PyStdlibTypeProvider.getQualifiedName(function, (PsiElement)callSite);
        if (qname != null) {
            if (OPEN_FUNCTIONS.contains(qname) && callSite != null) {
                PyType type;
                PyTypeChecker.AnalyzeCallResults results = PyTypeChecker.analyzeCallSite(callSite, context);
                if (results != null && (type = PyStdlibTypeProvider.getOpenFunctionType(qname, results.getArguments(), (PsiElement)callSite)) != null) {
                    return type;
                }
            } else {
                if ("__builtin__.tuple.__add__".equals(qname) && callSite instanceof PyBinaryExpression) {
                    return PyStdlibTypeProvider.getTupleConcatenationResultType((PyBinaryExpression)callSite, context);
                }
                if ("__builtin__.tuple.__mul__".equals(qname) && callSite instanceof PyBinaryExpression) {
                    return PyStdlibTypeProvider.getTupleMultiplicationResultType((PyBinaryExpression)callSite, context);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getTupleMultiplicationResultType(@NotNull PyBinaryExpression multiplication, @NotNull TypeEvalContext context) {
        PsiElement target;
        if (multiplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiplication", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getTupleMultiplicationResultType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getTupleMultiplicationResultType"));
        }
        PyTupleType leftTupleType = PyUtil.as(context.getType(multiplication.getLeftExpression()), PyTupleType.class);
        if (leftTupleType == null) {
            return null;
        }
        PyExpression rightExpression = multiplication.getRightExpression();
        if (rightExpression instanceof PyReferenceExpression && (target = ((PyReferenceExpression)rightExpression).getReference().resolve()) instanceof PyTargetExpression) {
            rightExpression = ((PyTargetExpression)target).findAssignedValue();
        }
        if (rightExpression instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)rightExpression).isIntegerLiteral()) {
            int multiplier = ((PyNumericLiteralExpression)rightExpression).getBigIntegerValue().intValue();
            int originalSize = leftTupleType.getElementCount();
            if (originalSize * multiplier <= 20) {
                PyType[] elementTypes = new PyType[leftTupleType.getElementCount() * multiplier];
                for (int i = 0; i < multiplier; ++i) {
                    for (int j = 0; j < originalSize; ++j) {
                        elementTypes[i * originalSize + j] = leftTupleType.getElementType(j);
                    }
                }
                return PyTupleType.create((PsiElement)multiplication, elementTypes);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getTupleConcatenationResultType(@NotNull PyBinaryExpression addition, @NotNull TypeEvalContext context) {
        if (addition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addition", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getTupleConcatenationResultType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getTupleConcatenationResultType"));
        }
        PyTupleType leftTupleType = PyUtil.as(context.getType(addition.getLeftExpression()), PyTupleType.class);
        if (addition.getRightExpression() != null) {
            PyTupleType rightTupleType = PyUtil.as(context.getType(addition.getRightExpression()), PyTupleType.class);
            if (leftTupleType != null && rightTupleType != null) {
                int i;
                PyType[] elementTypes = new PyType[leftTupleType.getElementCount() + rightTupleType.getElementCount()];
                for (i = 0; i < leftTupleType.getElementCount(); ++i) {
                    elementTypes[i] = leftTupleType.getElementType(i);
                }
                for (i = 0; i < rightTupleType.getElementCount(); ++i) {
                    elementTypes[i + leftTupleType.getElementCount()] = rightTupleType.getElementType(i);
                }
                return PyTupleType.create((PsiElement)addition, elementTypes);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getContextManagerVariableType(@NotNull PyClass contextManager, @NotNull PyExpression withExpression, @NotNull TypeEvalContext context) {
        PyExpression closee;
        if (contextManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextManager", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getContextManagerVariableType"));
        }
        if (withExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withExpression", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getContextManagerVariableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getContextManagerVariableType"));
        }
        if ("contextlib.closing".equals(contextManager.getQualifiedName()) && withExpression instanceof PyCallExpression && (closee = ((PyCallExpression)withExpression).getArgument(0, PyExpression.class)) != null) {
            return context.getType(closee);
        }
        String name = contextManager.getName();
        if ("FileIO".equals(name) || "TextIOWrapper".equals(name) || "IOBase".equals(name) || "_IOBase".equals(name)) {
            return context.getType(withExpression);
        }
        return null;
    }

    @Nullable
    private static PyType getNamedTupleType(@NotNull PsiElement referenceTarget, @Nullable PsiElement anchor) {
        PyFunction function;
        if (referenceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceTarget", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getNamedTupleType"));
        }
        if (referenceTarget instanceof PyTargetExpression) {
            Callable callable;
            PyCallExpression call;
            PyCallExpression.PyMarkedCallee callee;
            PyExpression value;
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            QualifiedName calleeName = target.getCalleeName();
            if (calleeName != null && "namedtuple".equals(calleeName.toString()) && (value = target.findAssignedValue()) instanceof PyCallExpression && (callee = (call = (PyCallExpression)value).resolveCallee(PyResolveContext.noImplicits())) != null && "collections.namedtuple".equals((callable = callee.getCallable()).getQualifiedName())) {
                return PyNamedTupleType.fromCall(call, 1);
            }
        } else if (referenceTarget instanceof PyFunction && anchor instanceof PyCallExpression && "namedtuple".equals((function = (PyFunction)referenceTarget).getName()) && "collections.namedtuple".equals(function.getQualifiedName())) {
            return PyNamedTupleType.fromCall((PyCallExpression)anchor, 2);
        }
        return null;
    }

    @Nullable
    private static PyType getOpenFunctionType(@NotNull String callQName, @NotNull Map<PyExpression, PyNamedParameter> arguments, @NotNull PsiElement anchor) {
        if (callQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callQName", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getOpenFunctionType"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getOpenFunctionType"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getOpenFunctionType"));
        }
        String mode = "r";
        for (Map.Entry<PyExpression, PyNamedParameter> entry : arguments.entrySet()) {
            PyNamedParameter parameter = entry.getValue();
            if (!"mode".equals(parameter.getName())) continue;
            PyExpression argument = entry.getKey();
            if (argument instanceof PyKeywordArgument) {
                argument = ((PyKeywordArgument)argument).getValueExpression();
            }
            if (!(argument instanceof PyStringLiteralExpression)) continue;
            mode = ((PyStringLiteralExpression)argument).getStringValue();
            break;
        }
        LanguageLevel level = LanguageLevel.forElement(anchor);
        if (mode.contains("b")) {
            return PyTypeParser.getTypeByName(anchor, BINARY_FILE_TYPE);
        }
        if (level.isPy3K() || "io.open".equals(callQName)) {
            return PyTypeParser.getTypeByName(anchor, TEXT_FILE_TYPE);
        }
        return PyTypeParser.getTypeByName(anchor, BINARY_FILE_TYPE);
    }

    @Nullable
    private static String getQualifiedName(@NotNull PyFunction f, @Nullable PsiElement callSite) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider", "getQualifiedName"));
        }
        if (!f.isValid()) {
            return null;
        }
        String result = f.getName();
        PyClass c = f.getContainingClass();
        VirtualFile vfile = f.getContainingFile().getVirtualFile();
        if (vfile != null) {
            QualifiedName qname;
            String module = QualifiedNameFinder.findShortestImportableName((PsiElement)(callSite != null ? callSite : f), vfile);
            if ("builtins".equals(module)) {
                module = "__builtin__";
            }
            if ((qname = PyStdlibCanonicalPathProvider.restoreStdlibCanonicalPath(QualifiedName.fromDottedString((String)(result = String.format("%s.%s%s", module, c != null ? c.getName() + "." : "", result))))) != null) {
                return qname.toString();
            }
        }
        return result;
    }
}

