/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyStdlibClassMembersProvider
extends PyClassMembersProviderBase {
    private Key<List<PyCustomMember>> mySocketMembersKey = Key.create((String)"socket.members");

    @Override
    @NotNull
    public Collection<PyCustomMember> getMembers(PyClassType classType, PsiElement location) {
        PyClass clazz = classType.getPyClass();
        String qualifiedName = clazz.getQualifiedName();
        if ("socket._socketobject".equals(qualifiedName)) {
            PyFile socketFile = (PyFile)clazz.getContainingFile();
            List<PyCustomMember> socketMembers = (List<PyCustomMember>)socketFile.getUserData(this.mySocketMembersKey);
            if (socketMembers == null) {
                socketMembers = PyStdlibClassMembersProvider.calcSocketMembers(socketFile);
                socketFile.putUserData(this.mySocketMembersKey, socketMembers);
            }
            List<PyCustomMember> list = socketMembers;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/stdlib/PyStdlibClassMembersProvider", "getMembers"));
            }
            return list;
        }
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/stdlib/PyStdlibClassMembersProvider", "getMembers"));
        }
        return list;
    }

    private static List<PyCustomMember> calcSocketMembers(PyFile socketFile) {
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        PyStdlibClassMembersProvider.addMethodsFromAttr(socketFile, result, "_socketmethods");
        PyStdlibClassMembersProvider.addMethodsFromAttr(socketFile, result, "_delegate_methods");
        return result;
    }

    private static void addMethodsFromAttr(PyFile socketFile, List<PyCustomMember> result, String attrName) {
        List<String> methods;
        PyTargetExpression socketMethods = socketFile.findTopLevelAttribute(attrName);
        if (socketMethods != null && (methods = PyUtil.getStringListFromTargetExpression(socketMethods)) != null) {
            for (String name : methods) {
                result.add(new PyCustomMember(name).resolvesTo("_socket").toClass("SocketType").toFunction(name));
            }
        }
    }
}

