/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStdlibCanonicalPathProvider
implements PyCanonicalPathProvider {
    @Override
    @Nullable
    public QualifiedName getCanonicalPath(@NotNull QualifiedName qName, PsiElement foothold) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/codeInsight/stdlib/PyStdlibCanonicalPathProvider", "getCanonicalPath"));
        }
        return PyStdlibCanonicalPathProvider.restoreStdlibCanonicalPath(qName);
    }

    public static QualifiedName restoreStdlibCanonicalPath(QualifiedName qName) {
        if (qName.getComponentCount() > 0) {
            List components = qName.getComponents();
            String head = (String)components.get(0);
            if (head.equals("_abcoll") || head.equals("_collections")) {
                components.set(0, "collections");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("posix") || head.equals("nt")) {
                components.set(0, "os");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("_functools")) {
                components.set(0, "functools");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("_struct")) {
                components.set(0, "struct");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("_io") || head.equals("_pyio") || head.equals("_fileio")) {
                components.set(0, "io");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("_datetime")) {
                components.set(0, "datetime");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("ntpath") || head.equals("posixpath") || head.equals("path")) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("os");
                components.set(0, "path");
                result.addAll(components);
                return QualifiedName.fromComponents(result);
            }
            if (head.equals("_sqlite3")) {
                components.set(0, "sqlite3");
                return QualifiedName.fromComponents((Collection)components);
            }
            if (head.equals("_pickle")) {
                components.set(0, "pickle");
                return QualifiedName.fromComponents((Collection)components);
            }
        }
        return null;
    }
}

