/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleType
extends PyClassTypeImpl
implements PyCallableType {
    private final String myName;
    private final int myDefinitionLevel;
    private final PsiElement myDeclaration;
    private final List<String> myFields;

    public PyNamedTupleType(PyClass tupleClass, PsiElement declaration, String name, List<String> fields, int definitionLevel) {
        super(tupleClass, definitionLevel > 0);
        this.myDeclaration = declaration;
        this.myFields = fields;
        this.myName = name;
        this.myDefinitionLevel = definitionLevel;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType", "resolveMember"));
        }
        List<? extends RatedResolveResult> classMembers = super.resolveMember(name, location, direction, resolveContext, inherited);
        if (classMembers != null && !classMembers.isEmpty()) {
            return classMembers;
        }
        if (this.myFields.contains(name)) {
            return Collections.singletonList(new RatedResolveResult(1000, (PsiElement)new PyElementImpl(this.myDeclaration.getNode())));
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        Collections.addAll(result, super.getCompletionVariants(completionPrefix, location, context));
        for (String field : this.myFields) {
            result.add(LookupElementBuilder.create((String)field));
        }
        return ArrayUtil.toObjectArray(result);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType", "getCallType"));
        }
        if (this.myDefinitionLevel > 0) {
            return new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, this.myFields, this.myDefinitionLevel - 1);
        }
        return null;
    }

    @Override
    public PyClassType toInstance() {
        return this.myDefinitionLevel == 1 ? new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, this.myFields, 0) : this;
    }

    @Override
    public String toString() {
        return "PyNamedTupleType: " + this.myName;
    }

    @Nullable
    public static PyType fromCall(PyCallExpression call, int level) {
        PyClass tuple;
        String name = PyPsiUtils.strValue(call.getArgument(0, PyExpression.class));
        PyExpression fieldNamesExpression = PyPsiUtils.flattenParens(call.getArgument(1, PyExpression.class));
        if (name == null || fieldNamesExpression == null) {
            return null;
        }
        List<String> fieldNames = null;
        if (fieldNamesExpression instanceof PySequenceExpression) {
            fieldNames = PyUtil.strListValue(fieldNamesExpression);
        } else {
            String fieldNamesString = PyPsiUtils.strValue(fieldNamesExpression);
            if (fieldNamesString != null) {
                fieldNames = PyNamedTupleType.parseFieldNamesString(fieldNamesString);
            }
        }
        if (fieldNames != null && (tuple = PyBuiltinCache.getInstance((PsiElement)call).getClass("__namedtuple")) != null) {
            return new PyNamedTupleType(tuple, (PsiElement)call, name, fieldNames, level);
        }
        return null;
    }

    private static List<String> parseFieldNamesString(String fieldNamesString) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : StringUtil.tokenize((String)fieldNamesString, (String)", ")) {
            result.add(name);
        }
        return result;
    }

    public int getElementCount() {
        return this.myFields.size();
    }
}

