/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.regexp;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.regexp.PythonRegexpLanguage;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRegexpInjector
implements MultiHostInjector {
    private final List<RegexpMethodDescriptor> myDescriptors = new ArrayList<RegexpMethodDescriptor>();

    public PythonRegexpInjector() {
        this.addMethod("compile");
        this.addMethod("search");
        this.addMethod("match");
        this.addMethod("split");
        this.addMethod("findall");
        this.addMethod("finditer");
        this.addMethod("sub");
        this.addMethod("subn");
    }

    private void addMethod(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "addMethod"));
        }
        this.myDescriptors.add(new RegexpMethodDescriptor(name, 0));
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "getLanguagesToInject"));
        }
        PsiElement contextParent = context.getParent();
        if (PyInjectionUtil.getLargestStringLiteral(context) == context && contextParent instanceof PyArgumentList) {
            PsiElement element;
            PsiPolyVariantReference ref;
            PyExpression callee;
            Object[] args = ((PyArgumentList)contextParent).getArguments();
            int index = ArrayUtil.indexOf((Object[])args, (Object)context);
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PyCallExpression.class);
            if (call != null && (callee = call.getCallee()) instanceof PyReferenceExpression && this.canBeRegexpCall(callee) && (ref = ((PyReferenceExpression)callee).getReference(PyResolveContext.noImplicits())) != null && (element = ref.resolve()) != null && ScopeUtil.getScopeOwner(element) instanceof PyFile && element.getContainingFile().getName().equals("re.py") && this.isRegexpMethod(element, index)) {
                Language language = PythonRegexpInjector.isVerbose(call) ? PythonVerboseRegexpLanguage.INSTANCE : PythonRegexpLanguage.INSTANCE;
                registrar.startInjecting(language);
                PyInjectionUtil.InjectionResult result = PyInjectionUtil.registerStringLiteralInjection(context, registrar);
                if (result.isInjected()) {
                    PsiFile file;
                    registrar.doneInjecting();
                    if (!result.isStrict() && (file = PythonRegexpInjector.getInjectedFile(registrar)) != null) {
                        file.putUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
                    }
                }
            }
        }
    }

    @Nullable
    private static PsiFile getInjectedFile(@NotNull MultiHostRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "getInjectedFile"));
        }
        List<Pair<Place, PsiFile>> result = ((MultiHostRegistrarImpl)registrar).getResult();
        return result == null || result.isEmpty() ? null : (PsiFile)result.get((int)(result.size() - 1)).second;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "elementsToInjectIn"));
        }
        return list;
    }

    private static boolean isVerbose(@NotNull PyCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "isVerbose"));
        }
        PyExpression[] arguments = call.getArguments();
        if (arguments.length <= 1) {
            return false;
        }
        return PythonRegexpInjector.isVerbose(arguments[arguments.length - 1]);
    }

    private static boolean isVerbose(@Nullable PyExpression expr) {
        if (expr instanceof PyKeywordArgument) {
            PyKeywordArgument keywordArgument = (PyKeywordArgument)expr;
            if (!"flags".equals(keywordArgument.getName())) {
                return false;
            }
            return PythonRegexpInjector.isVerbose(keywordArgument.getValueExpression());
        }
        if (expr instanceof PyReferenceExpression) {
            return "VERBOSE".equals(((PyReferenceExpression)expr).getReferencedName());
        }
        if (expr instanceof PyBinaryExpression) {
            return PythonRegexpInjector.isVerbose(((PyBinaryExpression)expr).getLeftExpression()) || PythonRegexpInjector.isVerbose(((PyBinaryExpression)expr).getRightExpression());
        }
        return false;
    }

    private boolean isRegexpMethod(@NotNull PsiElement element, int index) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "isRegexpMethod"));
        }
        if (!(element instanceof PyFunction)) {
            return false;
        }
        String name = ((PyFunction)element).getName();
        for (RegexpMethodDescriptor descriptor : this.myDescriptors) {
            if (!descriptor.methodName.equals(name) || descriptor.argIndex != index) continue;
            return true;
        }
        return false;
    }

    private boolean canBeRegexpCall(@NotNull PyExpression callee) {
        if (callee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callee", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector", "canBeRegexpCall"));
        }
        String text = callee.getText();
        for (RegexpMethodDescriptor descriptor : this.myDescriptors) {
            if (!text.endsWith(descriptor.methodName)) continue;
            return true;
        }
        return false;
    }

    private static class RegexpMethodDescriptor {
        @NotNull
        private final String methodName;
        private final int argIndex;

        private RegexpMethodDescriptor(@NotNull String methodName, int argIndex) {
            if (methodName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector$RegexpMethodDescriptor", "<init>"));
            }
            this.methodName = methodName;
            this.argIndex = argIndex;
        }
    }
}

