/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SpeedSearchComparator;
import com.jetbrains.python.codeInsight.override.PyMethodMember;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOverrideImplementUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.override.PyOverrideImplementUtil");

    private PyOverrideImplementUtil() {
    }

    @Nullable
    public static PyClass getContextClass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PyClass pyClass;
        PsiElement lastChild;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "getContextClass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "getContextClass"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "getContextClass"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null && (lastChild = file.getLastChild()) != null && offset >= lastChild.getTextRange().getStartOffset() && offset <= lastChild.getTextRange().getEndOffset()) {
            element = lastChild;
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof PyClass) {
            return (PyClass)element.getPrevSibling();
        }
        return pyClass;
    }

    public static void chooseAndOverrideMethods(Project project, @NotNull Editor editor, @NotNull PyClass pyClass) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideMethods"));
        }
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideMethods"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, pyClass);
    }

    private static void chooseAndOverrideOrImplementMethods(Project project, @NotNull Editor editor, @NotNull PyClass pyClass) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        LOG.assertTrue(pyClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<PyFunction> superFunctions = PyOverrideImplementUtil.getAllSuperFunctions(pyClass);
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, pyClass, superFunctions, "Select Methods to Override", false);
    }

    public static void chooseAndOverrideOrImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass pyClass, @NotNull Collection<PyFunction> superFunctions, @NotNull String title, boolean implement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (superFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunctions", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        ArrayList<PyMethodMember> elements = new ArrayList<PyMethodMember>();
        for (PyFunction function : superFunctions) {
            String name = function.getName();
            if (name == null || PyUtil.isClassPrivateName(name) || pyClass.findMethodByName(name, false) != null) continue;
            PyMethodMember member = new PyMethodMember(function);
            elements.add(member);
        }
        if (elements.size() == 0) {
            return;
        }
        MemberChooser<PyMethodMember> chooser = new MemberChooser<PyMethodMember>(elements.toArray(new PyMethodMember[elements.size()]), false, true, project){

            @Override
            protected SpeedSearchComparator getSpeedSearchComparator() {
                return new SpeedSearchComparator(false){

                    @Override
                    @Nullable
                    public Iterable<TextRange> matchingFragments(String pattern, String text) {
                        return super.matchingFragments(PyMethodMember.trimUnderscores(pattern), text);
                    }
                };
            }
        };
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return;
        }
        List<PyMethodMember> membersToOverride = chooser.getSelectedElements();
        PyOverrideImplementUtil.overrideMethods(editor, pyClass, membersToOverride, implement);
    }

    public static void overrideMethods(final Editor editor, final PyClass pyClass, final List<PyMethodMember> membersToOverride, final boolean implement) {
        if (membersToOverride == null) {
            return;
        }
        new WriteCommandAction(pyClass.getProject(), new PsiFile[]{pyClass.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil$2", "run"));
                }
                PyOverrideImplementUtil.write(pyClass, membersToOverride, editor, implement);
            }
        }.execute();
    }

    private static void write(@NotNull PyClass pyClass, @NotNull List<PyMethodMember> newMembers, @NotNull Editor editor, boolean implement) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "write"));
        }
        if (newMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMembers", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "write"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "write"));
        }
        PyStatementList statementList = pyClass.getStatementList();
        int offset = editor.getCaretModel().getOffset();
        PyStatement anchor = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (statement.getTextRange().getStartOffset() >= offset && (!(statement instanceof PyExpressionStatement) || !(((PyExpressionStatement)statement).getExpression() instanceof PyStringLiteralExpression))) continue;
            anchor = statement;
        }
        PyFunction element = null;
        for (PyMethodMember newMember : newMembers) {
            PyFunction baseFunction = (PyFunction)newMember.getPsiElement();
            PyFunctionBuilder builder = PyOverrideImplementUtil.buildOverriddenFunction(pyClass, baseFunction, implement);
            PyFunction function = builder.addFunctionAfter((PsiElement)statementList, (PsiElement)anchor, LanguageLevel.forElement((PsiElement)statementList));
            element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
        }
        PyPsiUtils.removeRedundantPass(statementList);
        if (element != null) {
            PyStatementList targetStatementList = element.getStatementList();
            int start = targetStatementList.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(start);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(start, element.getTextRange().getEndOffset());
        }
    }

    private static PyFunctionBuilder buildOverriddenFunction(PyClass pyClass, PyFunction baseFunction, boolean implement) {
        PyAnnotation anno;
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(baseFunction.getName());
        PyDecoratorList decorators = baseFunction.getDecoratorList();
        if (decorators != null) {
            if (decorators.findDecorator("classmethod") != null) {
                pyFunctionBuilder.decorate("classmethod");
            } else if (decorators.findDecorator("staticmethod") != null) {
                pyFunctionBuilder.decorate("staticmethod");
            }
        }
        if ((anno = baseFunction.getAnnotation()) != null) {
            pyFunctionBuilder.annotation(anno.getText());
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(baseFunction.getProject(), baseFunction.getContainingFile());
        List<PyParameter> baseParams = PyUtil.getParameters(baseFunction, context);
        for (PyParameter parameter : baseParams) {
            pyFunctionBuilder.parameter(parameter.getText());
        }
        PyClass baseClass = baseFunction.getContainingClass();
        assert (baseClass != null);
        StringBuilder statementBody = new StringBuilder();
        boolean hadStar = false;
        ArrayList<String> parameters = new ArrayList<String>();
        for (PyParameter parameter : baseParams) {
            PyNamedParameter pyNamedParameter = parameter.getAsNamed();
            if (pyNamedParameter != null) {
                String repr = pyNamedParameter.getRepr(false);
                parameters.add(hadStar && !pyNamedParameter.isKeywordContainer() ? pyNamedParameter.getName() + "=" + repr : repr);
                if (!pyNamedParameter.isPositionalContainer()) continue;
                hadStar = true;
                continue;
            }
            if (parameter instanceof PySingleStarParameter) {
                hadStar = true;
                continue;
            }
            parameters.add(parameter.getText());
        }
        if ("___Classobj".equals(baseClass.getName()) || PyOverrideImplementUtil.raisesNotImplementedError(baseFunction) || implement) {
            statementBody.append("pass");
        } else {
            if (!"__init__".equals(baseFunction.getName()) && context.getReturnType(baseFunction) != PyNoneType.INSTANCE) {
                statementBody.append("return ");
            }
            if (baseClass.isNewStyleClass()) {
                statementBody.append("super");
                statementBody.append("(");
                LanguageLevel langLevel = ((PyFile)pyClass.getContainingFile()).getLanguageLevel();
                if (!langLevel.isPy3K()) {
                    String baseFirstName = !baseParams.isEmpty() ? baseParams.get(0).getName() : null;
                    String firstName = baseFirstName != null ? baseFirstName : "self";
                    PsiElement outerClass = PsiTreeUtil.getParentOfType((PsiElement)pyClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    String className = pyClass.getName();
                    ArrayList nameResult = Lists.newArrayList((Object[])new String[]{className});
                    while (outerClass != null) {
                        nameResult.add(0, ((PyClass)outerClass).getName());
                        outerClass = PsiTreeUtil.getParentOfType((PsiElement)outerClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    }
                    className = StringUtil.join((Collection)nameResult, (String)".");
                    statementBody.append(className).append(", ").append(firstName);
                }
                statementBody.append(").").append(baseFunction.getName()).append("(");
                if (parameters.size() > 0) {
                    parameters.remove(0);
                }
            } else {
                statementBody.append(PyOverrideImplementUtil.getReferenceText(pyClass, baseClass)).append(".").append(baseFunction.getName()).append("(");
            }
            statementBody.append(StringUtil.join(parameters, (String)", "));
            statementBody.append(")");
        }
        pyFunctionBuilder.statement(statementBody.toString());
        return pyFunctionBuilder;
    }

    public static boolean raisesNotImplementedError(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "raisesNotImplementedError"));
        }
        for (PyStatement statement : function.getStatementList().getStatements()) {
            PyExpression callee;
            PyExpression firstExpression;
            PyRaiseStatement raiseStatement;
            PyExpression[] expressions;
            if (!(statement instanceof PyRaiseStatement) || (expressions = (raiseStatement = (PyRaiseStatement)statement).getExpressions()).length <= 0 || !((firstExpression = expressions[0]) instanceof PyCallExpression ? (callee = ((PyCallExpression)firstExpression).getCallee()) != null && callee.getText().equals("NotImplementedError") : firstExpression.getText().equals("NotImplementedError"))) continue;
            return true;
        }
        return false;
    }

    private static String getReferenceText(PyClass fromClass, PyClass toClass) {
        PyExpression[] superClassExpressions;
        for (PyExpression expression : superClassExpressions = fromClass.getSuperClassExpressions()) {
            PsiElement target;
            if (!(expression instanceof PyReferenceExpression) || (target = ((PyReferenceExpression)expression).getReference().resolve()) != toClass) continue;
            return expression.getText();
        }
        return toClass.getName();
    }

    @NotNull
    public static Collection<PyFunction> getAllSuperFunctions(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "getAllSuperFunctions"));
        }
        HashMap<String, PyFunction> superFunctions = new HashMap<String, PyFunction>();
        for (PyClass aClass : pyClass.getAncestorClasses()) {
            for (PyFunction function : aClass.getMethods(false)) {
                if (superFunctions.containsKey(function.getName())) continue;
                superFunctions.put(function.getName(), function);
            }
        }
        Collection<PyFunction> collection = superFunctions.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil", "getAllSuperFunctions"));
        }
        return collection;
    }
}

