/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.liveTemplates.PythonTemplateContextType;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIterableVariableMacro
extends Macro {
    public String getName() {
        return "pyIterableVariable";
    }

    public String getPresentableName() {
        return "pyIterableVariable()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, @NotNull ExpressionContext context) {
        List<PsiNamedElement> components;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "calculateResult"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "calculateResult"));
        }
        PsiElement element = context.getPsiElementAtStartOffset();
        if (element != null && !(components = this.getIterableElements(element)).isEmpty()) {
            return new PsiElementResult((PsiElement)components.get(0));
        }
        return null;
    }

    @Nullable
    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "calculateLookupItems"));
        }
        ArrayList<LookupElementBuilder> results = new ArrayList<LookupElementBuilder>();
        PsiElement element = context.getPsiElementAtStartOffset();
        if (element != null) {
            for (PsiNamedElement iterableElement : this.getIterableElements(element)) {
                results.add(LookupElementBuilder.create((PsiNamedElement)iterableElement));
            }
        }
        return results.toArray(new LookupElement[results.size()]);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof PythonTemplateContextType;
    }

    @NotNull
    protected List<PsiNamedElement> getIterableElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "getIterableElements"));
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile());
        ArrayList<PsiNamedElement> components = new ArrayList<PsiNamedElement>();
        for (PsiNamedElement namedElement : PyIterableVariableMacro.getVisibleNamedElements(element)) {
            PyType type;
            if (!(namedElement instanceof PyTypedElement) || (type = typeEvalContext.getType((PyTypedElement)namedElement)) == null || !PyABCUtil.isSubtype(type, "Iterable", typeEvalContext)) continue;
            components.add(namedElement);
        }
        ArrayList<PsiNamedElement> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "getIterableElements"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiNamedElement> getVisibleNamedElements(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "getVisibleNamedElements"));
        }
        ArrayList<PsiNamedElement> results = new ArrayList<PsiNamedElement>();
        ScopeOwner owner = ScopeUtil.getScopeOwner(anchor);
        while (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            results.addAll(scope.getNamedElements());
            for (PyImportedNameDefiner importedNameDefiner : scope.getImportedNameDefiners()) {
                for (PyElement importedElement : importedNameDefiner.iterateNames()) {
                    if (!(importedElement instanceof PsiNamedElement)) continue;
                    results.add((PsiNamedElement)importedElement);
                }
            }
            owner = ScopeUtil.getScopeOwner((PsiElement)owner);
        }
        ArrayList<PsiNamedElement> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/liveTemplates/PyIterableVariableMacro", "getVisibleNamedElements"));
        }
        return arrayList;
    }
}

