/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.liveTemplates.PythonTemplateContextType;
import com.jetbrains.python.psi.PyClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassNameMacro
extends Macro {
    public String getName() {
        return "pyClassName";
    }

    public String getPresentableName() {
        return "pyClassName()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/python/codeInsight/liveTemplates/PyClassNameMacro", "calculateResult"));
        }
        PsiElement place = context.getPsiElementAtStartOffset();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)place, PyClass.class);
        if (pyClass == null) {
            return null;
        }
        String name = pyClass.getName();
        return name == null ? null : new TextResult(name);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof PythonTemplateContextType;
    }
}

