/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeIntention
implements IntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/TypeIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        this.updateText(false);
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        if (this.isAvailableForParameter(project, elementAt)) {
            return true;
        }
        if (this.isAvailableForReturn(elementAt)) {
            this.updateText(true);
            return true;
        }
        return false;
    }

    private boolean isAvailableForParameter(Project project, PsiElement elementAt) {
        ResolveResult[] results;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyLambdaExpression.class) != null) {
            return false;
        }
        PsiReference reference = problemElement.getReference();
        if (reference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)reference).multiResolve(false)).length != 1) {
            return false;
        }
        VirtualFile virtualFile = problemElement.getContainingFile().getVirtualFile();
        if (virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        PsiElement resolved = reference != null ? reference.resolve() : null;
        PyParameter parameter = TypeIntention.getParameter(problemElement, resolved);
        return parameter != null && !this.isParamTypeDefined(parameter);
    }

    @Nullable
    protected static PyExpression getProblemElement(@Nullable PsiElement elementAt) {
        PyExpression qualifier;
        PyExpression problemElement = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, (Class[])new Class[]{PyNamedParameter.class, PyReferenceExpression.class});
        if (problemElement == null) {
            return null;
        }
        if (problemElement instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)problemElement).getQualifier()) != null && !qualifier.getText().equals("self")) {
            problemElement = qualifier;
        }
        return problemElement;
    }

    protected abstract void updateText(boolean var1);

    protected boolean isParamTypeDefined(PyParameter parameter) {
        return false;
    }

    @Nullable
    protected static PyParameter getParameter(PyExpression problemElement, PsiElement resolved) {
        PyParameter parameter;
        PyParameter pyParameter = parameter = problemElement instanceof PyParameter ? (PyParameter)((Object)problemElement) : null;
        if (resolved instanceof PyParameter) {
            parameter = (PyParameter)resolved;
        }
        return parameter;
    }

    private boolean isAvailableForReturn(@NotNull PsiElement elementAt) {
        ResolveResult[] results;
        PyCallExpression callExpression;
        ASTNode nameNode;
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/jetbrains/python/codeInsight/intentions/TypeIntention", "isAvailableForReturn"));
        }
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        if (parentFunction != null && (nameNode = parentFunction.getNameNode()) != null) {
            PsiElement prev = elementAt.getContainingFile().findElementAt(elementAt.getTextOffset() - 1);
            if (nameNode.getPsi() == elementAt || nameNode.getPsi() == prev) {
                return !this.isReturnTypeDefined(parentFunction);
            }
        }
        if ((callExpression = TypeIntention.getCallExpression(elementAt)) == null) {
            return false;
        }
        PyExpression callee = callExpression.getCallee();
        if (callee == null) {
            return false;
        }
        PsiReference reference = callee.getReference();
        if (reference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)reference).multiResolve(false)).length == 1) {
            PsiElement result = results[0].getElement();
            if (!(result instanceof PyFunction)) {
                return false;
            }
            PsiFile psiFile = result.getContainingFile();
            if (psiFile == null) {
                return false;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
                return false;
            }
            return !this.isReturnTypeDefined((PyFunction)result);
        }
        return false;
    }

    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/intentions/TypeIntention", "isReturnTypeDefined"));
        }
        return false;
    }

    @Nullable
    protected static PyCallExpression getCallExpression(PsiElement elementAt) {
        PyExpression assignedValue;
        PyAssignmentStatement assignmentStatement;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement != null) {
            PyExpression assignedValue2;
            PsiElement resolved;
            PsiReference reference = problemElement.getReference();
            PsiElement psiElement = resolved = reference != null ? reference.resolve() : null;
            if (resolved instanceof PyTargetExpression && (assignedValue2 = ((PyTargetExpression)resolved).findAssignedValue()) instanceof PyCallExpression) {
                return (PyCallExpression)assignedValue2;
            }
        }
        if ((assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyAssignmentStatement.class)) != null && (assignedValue = assignmentStatement.getAssignedValue()) instanceof PyCallExpression) {
            return (PyCallExpression)assignedValue;
        }
        return (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyCallExpression.class, (boolean)false);
    }

    @Nullable
    protected Callable getCallable(PsiElement elementAt) {
        PyCallExpression callExpression = TypeIntention.getCallExpression(elementAt);
        if (callExpression != null && elementAt != null) {
            Callable callable = callExpression.resolveCalleeFunction(this.getResolveContext(elementAt));
            return callable == null ? (Callable)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class) : callable;
        }
        return (Callable)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
    }

    protected PyResolveContext getResolveContext(@NotNull PsiElement origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/python/codeInsight/intentions/TypeIntention", "getResolveContext"));
        }
        return PyResolveContext.defaultContext().withTypeEvalContext(TypeEvalContext.codeAnalysis(origin.getProject(), origin.getContainingFile()));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

